package com.rapid.im.framework.network.executor.servlet;

import java.io.IOException;

import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;

import com.rapid.im.framework.network.configure.domain.NetConfigurer;
import com.rapid.im.framework.network.configure.domain.NetFunctionResponse;
import com.rapid.im.framework.network.executor.parameter.NetFunctionRequestPreparement;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.http.HttpResponseEntity;
import com.rapid.j2ee.framework.core.io.json.JsonUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class NetFunctionJsonFileResponser extends
		NetFunctionAbstractResponser<HttpResponseEntity> {

	public NetFunctionJsonFileResponser(NetConfigurer netConfigurer,
			NetFunctionResponse netFunctionResponse) {
		super(netConfigurer, netFunctionResponse);

	}

	@Override
	protected Object doParse(String className,
			HttpResponseEntity httpResponseEntity,
			NetFunctionResponse netFunctionResponse,
			NetFunctionRequestPreparement requestPreparement) {

		if (TypeChecker.isJsonContextType(httpResponseEntity.getContentType()
				.getValue())) {

			try {
				return JsonUtils.jsonToBean(ClassUtils.forName(className),
						EntityUtils.toString(httpResponseEntity, Charsets.UTF_8
								.getCharset()));
			} catch (Exception e) {
				throw ExceptionUtils.convertThrowableToBaseException(e);
			}
		}

		return this.putFile(className, httpResponseEntity, netFunctionResponse,
				requestPreparement);
	}

	protected abstract Object putFile(String className,
			HttpResponseEntity httpResponseEntity,
			NetFunctionResponse netFunctionResponse,
			NetFunctionRequestPreparement requestPreparement);

}
