package com.rapid.im.framework.weixin;

import java.io.File;

import org.springframework.beans.factory.annotation.Autowired;

import com.rapid.im.framework.weixin.basic.WeiXinBasicSecurityService;
import com.rapid.im.framework.weixin.basic.domain.WeiXinSecurityToken;
import com.rapid.im.framework.weixin.constants.WeiXinMediaType;
import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.io.file.FileWriter;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.orm.exportsql.ExportSqlTemplateGenerator;
import com.rapid.j2ee.framework.orm.medium.javabeanscript.MediumPersistentBeanJavaSourceGenerator;
import com.rapid.j2ee.framework.unit.AbstractSpringMainUnit;
import com.rapid.j2ee.framework.unit.SpringApplicationContext;
import com.rapid.j2ee.framework.unit.UnitTest;
import com.rapid.j2ee.framework.unit.UnitTestBefore;

@SpringApplicationContext( { "spring_weixin_appconfig_app.xml" })
public class WeiXinTester extends AbstractSpringMainUnit {

	public WeiXinTester() {
		super();
	}

	@UnitTestBefore
	public void doGetTokenAccess() {

		weiXinSecurityToken = weiXinBasicSecurityService
				.getAccessToken("LiLy");

		System.out.println("Token Access:" + weiXinBasicSecurityService);
	}

	@UnitTest
	public void doGetIMServerIPs() {

		System.out
				.println("IM Server IPs:"
						+ weiXinBasicSecurityService.getWeiXinServerIP(
								weiXinSecurityToken.getAccess_token())
								.getIPListBunch());
	}
	@UnitTest
	public void doUploadMedia(){
		System.out.println( weiXinBasicSecurityService.uploadMedia(WeiXinMediaType.Image, weiXinSecurityToken.getAccess_token(), new File("C:/Users/Administrator/Pictures/22CF3973-4282-4106-8EAD-7A5EFA8F03C0.jpg")));
	}

	public static void main(String[] args) {
		new WeiXinTester();
	}

	@Autowired
	private WeiXinBasicSecurityService weiXinBasicSecurityService;

	private WeiXinSecurityToken weiXinSecurityToken;
}
