package com.rapid.im.framework.weixin.basic;

import java.io.File;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.rapid.im.framework.network.executor.NetFunctionGenericExecutor;
import com.rapid.im.framework.network.executor.parameter.*;
import com.rapid.im.framework.weixin.basic.domain.WeiXinMedia;
import com.rapid.im.framework.weixin.basic.domain.WeiXinSecurityToken;
import com.rapid.im.framework.weixin.basic.domain.WeiXinServerIP;
import com.rapid.im.framework.weixin.constants.WeiXinFunctionCategory;
import com.rapid.im.framework.weixin.constants.WeiXinMediaType;

@Service
public class WeiXinBasicSecurityServiceImpl implements
		WeiXinBasicSecurityService {

	public WeiXinSecurityToken getAccessToken(String applicationCode) {

		NetFunctionRequestPreparement requestPreparement = new NetFunctionRequestPreparement(
				WeiXinFunctionCategory.BasicSupport_AccessToken);

		return (WeiXinSecurityToken) weiXinFunctionGenericExecutor.execute(
				applicationCode, requestPreparement);
	}

	public WeiXinServerIP getWeiXinServerIP(String accessToken) {

		NetFunctionRequestPreparement requestPreparement = new NetFunctionRequestPreparement(
				WeiXinFunctionCategory.BasicSupport_IM_ServerIPs);

		requestPreparement.addAccessToken(accessToken);

		return (WeiXinServerIP) weiXinFunctionGenericExecutor
				.execute(requestPreparement);
	}

	public WeiXinMedia uploadMedia(WeiXinMediaType weiXinMediaType,
			String accessToken, File mediaResource) {

		NetFunctionRequestPreparement requestPreparement = new NetFunctionRequestPreparement(
				WeiXinFunctionCategory.BasicSupport_Upload_Media);

		requestPreparement.addAccessToken(accessToken);

		requestPreparement.addUrlParameter("type", weiXinMediaType.getType());
		
		requestPreparement.addContentMediaResource(mediaResource);

		return (WeiXinMedia) weiXinFunctionGenericExecutor
				.execute(requestPreparement);
	}

	@Autowired
	@Qualifier("WeiXinFunctionGenericExecutor")
	private NetFunctionGenericExecutor weiXinFunctionGenericExecutor;

}
