package com.rapid.j2ee.framework;

import java.math.BigDecimal;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.utils.PropertiesUtils;

@Component("ProjectLaunchAnnouncement")
public class ProjectLaunchAnnouncement {

	private static boolean hasAnnounced = false;

	public ProjectLaunchAnnouncement() {

		if (hasAnnounced) {
			return;
		}

		hasAnnounced = true;

		Log logger = LogFactory.getLog(ProjectLaunchAnnouncement.class);

		Properties properties = PropertiesUtils.getProperties(
				"RapidFrameworkApp.properties", true);

		StringBuilder annourncement = new StringBuilder(1000);

		annourncement
				.append("\n//*******************************************************************************************************************");
		annourncement
				.append("\n*******************************************************************************************************************");
		annourncement
				.append("\n*******************************************************************************************************************\n\n");
		annourncement.append(properties
				.getProperty("RapidFramework.Product.Introduce"));

		annourncement
				.append("\n\n*******************************************************************************************************************");
		annourncement
				.append("\n*******************************************************************************************************************");

		annourncement
				.append("\n*******************************************************************************************************************//\n\n");

		System.out.println(annourncement);

		logger.info(annourncement);
	}

	

}
