package com.rapid.j2ee.framework.batchjob.domain;

import java.util.Date;

import com.rapid.j2ee.framework.batchjob.constants.RapidSystemBatchJobTaskStatus;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.annotation.Column;
import com.rapid.j2ee.framework.orm.medium.annotation.Creator;
import com.rapid.j2ee.framework.orm.medium.annotation.CreatorDate;
import com.rapid.j2ee.framework.orm.medium.annotation.ID;
import com.rapid.j2ee.framework.orm.medium.annotation.Table;
import com.rapid.j2ee.framework.orm.medium.annotation.ID.IDMode;
import com.rapid.j2ee.framework.orm.medium.bean.BaseMediumBean;

/**
 * 系统JOB日志
 * 
 * @author John Hao
 * 
 */
@Table("RP_SYSTEM_JOB_LOG")
public class SystemBatchJobTask extends BaseMediumBean implements
		java.io.Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Job PK
	 */
	@Column
	@ID
	private String jobId;

	/**
	 * JOB关联ID
	 */
	@Column
	@ID(IDMode.QUERY)
	private String jobReferNo;

	/**
	 * JOB关联ID2
	 */
	@Column
	@ID(IDMode.QUERY)
	private String jobReferNo2;

	/**
	 * JOB关联ID3
	 */
	@Column
	@ID(IDMode.QUERY)
	private String jobReferNo3;

	/**
	 * JOB关联ID4
	 */
	@Column
	@ID(IDMode.QUERY)
	private String jobReferNo4;

	/**
	 * JOB关联ID5
	 */
	@Column
	@ID(IDMode.QUERY)
	private String jobReferNo5;

	/**
	 * JOB 功能类型
	 */
	@Column
	@ID(IDMode.QUERY)
	private String jobFuncType;

	/**
	 * JOB 功能子类型
	 */
	@Column
	@ID(IDMode.QUERY)
	private String jobFuncSubType;

	/**
	 * Job Request 信息Path
	 */
	@Column
	private String jobRequestPath;

	/**
	 * Job Response 信息Path
	 */
	@Column
	private String jobResponsePath;

	/**
	 * 
	 * UnReady("UNRD", "未准备"), UnProcessed("UNPC", "可处理"), Processing("PCNG",
	 * "处理中..."), Success("SUCC", "成功"), FAILURE("FAIL", "业务失败"), ERROR( "ERRO",
	 * "系统Exp"), Cancel("CANL", "Cancel");
	 * 
	 */
	@Column
	@ID(IDMode.QUERY)
	private String jobStatus = RapidSystemBatchJobTaskStatus.UnProcessed
			.getStatus();

	/**
	 * 原来的Job 状态
	 */
	private String originalJobStatus;

	/**
	 * JOB Response 结果Code
	 */
	@Column
	private String jobResponseCode;

	/**
	 * JOB Response 结果信息
	 */
	@Column
	private String jobResponseMessage;

	/**
	 * 
	 * JOB 开始时间
	 */
	@Column
	private Date jobStartDate;

	/**
	 * JOB结束时间
	 */
	@Column
	private Date jobEndDate;

	/**
	 * JOB 异常原因
	 */
	@Column
	private String jobExpErrorReason;

	/**
	 * 运行 JOB Server 信息
	 */
	private String jobProcessServer;

	/**
	 * JOB执行次数
	 * 
	 * JOB_EXEC_COUNT
	 */
	private int jobExecCount = 0;

	/**
	 * 创建者ID
	 */
	@Column
	@Creator
	private String createAccountId;

	/**
	 * 创建时间
	 */
	@Column
	@CreatorDate
	private Date createDate;

	private String[] jobReferNos;

	@Column
	private Date nextFireDate;

	public SystemBatchJobTask() {

	}

	public SystemBatchJobTask(Class jobFuncTypeClass, String... jobReferNos) {

		this.jobFuncType = jobFuncTypeClass.getSimpleName();

		if (TypeChecker.isEmpty(jobReferNos)) {
			return;
		}

		for (int i = 0; i < jobReferNos.length; i++) {

			if (i == 0) {
				this.jobReferNo = StringUtils.trimToEmpty(jobReferNos[i]);
			} else if (i == 1) {
				this.jobReferNo2 = StringUtils.trimToEmpty(jobReferNos[i]);
			} else if (i == 2) {
				this.jobReferNo3 = StringUtils.trimToEmpty(jobReferNos[i]);
			} else if (i == 3) {
				this.jobReferNo4 = StringUtils.trimToEmpty(jobReferNos[i]);
			} else if (i == 4) {
				this.jobReferNo5 = StringUtils.trimToEmpty(jobReferNos[i]);
			}

		}

	}

	public int getJobExecCount() {
		return jobExecCount;
	}

	public void setJobExecCount(int jobExecCount) {
		this.jobExecCount = jobExecCount;
	}

	public String getJobId() {
		return jobId;
	}

	public void setJobId(String jobId) {
		this.jobId = jobId;
	}

	public Date getJobEndDate() {
		return jobEndDate;
	}

	public void setJobEndDate(Date jobEndDate) {
		this.jobEndDate = jobEndDate;
	}

	public String getJobExpErrorReason() {
		return jobExpErrorReason;
	}

	public void setJobExpErrorReason(String jobExpErrorReason) {
		this.jobExpErrorReason = jobExpErrorReason;
	}

	public String getJobFuncSubType() {
		return jobFuncSubType;
	}

	public void setJobFuncSubType(String jobFuncSubType) {
		this.jobFuncSubType = jobFuncSubType;
	}

	public String getJobFuncType() {
		return jobFuncType;
	}

	public void setJobFuncType(String jobFuncType) {
		this.jobFuncType = jobFuncType;
	}

	public String getJobReferNo() {
		return jobReferNo;
	}

	public void setJobReferNo(String jobReferNo) {
		this.jobReferNo = jobReferNo;
	}

	public String getJobReferNo2() {
		return jobReferNo2;
	}

	public void setJobReferNo2(String jobReferNo2) {
		this.jobReferNo2 = jobReferNo2;
	}

	public String getJobReferNo3() {
		return jobReferNo3;
	}

	public void setJobReferNo3(String jobReferNo3) {
		this.jobReferNo3 = jobReferNo3;
	}

	public String getJobResponseCode() {
		return jobResponseCode;
	}

	public void setJobResponseCode(String jobResponseCode) {
		this.jobResponseCode = jobResponseCode;
	}

	public String getJobRequestPath() {
		return jobRequestPath;
	}

	public void setJobRequestPath(String jobRequestPath) {
		this.jobRequestPath = jobRequestPath;
	}

	public String getJobResponsePath() {
		return jobResponsePath;
	}

	public void setJobResponsePath(String jobResponsePath) {
		this.jobResponsePath = jobResponsePath;
	}

	public String getJobResponseMessage() {
		return jobResponseMessage;
	}

	public void setJobResponseMessage(String jobResponseMessage) {
		this.jobResponseMessage = jobResponseMessage;
	}

	public Date getJobStartDate() {
		return jobStartDate;
	}

	public void setJobStartDate(Date jobStartDate) {
		this.jobStartDate = jobStartDate;
	}

	public String getJobStatus() {
		return jobStatus;
	}

	public void setJobStatus(String jobStatus) {
		this.jobStatus = jobStatus;
	}

	public String getOriginalJobStatus() {
		return originalJobStatus;
	}

	public void setOriginalJobStatus(String originalJobStatus) {
		this.originalJobStatus = originalJobStatus;
	}

	public void followJobStatusForOriginalJobStatus() {
		this.originalJobStatus = this.jobStatus;
	}

	public String getJobProcessServer() {
		return jobProcessServer;
	}

	public void setJobProcessServer(String jobProcessServer) {
		this.jobProcessServer = jobProcessServer;
	}

	public String getCreateAccountId() {
		return createAccountId;
	}

	public void setCreateAccountId(String createAccountId) {
		this.createAccountId = createAccountId;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public String getJobReferNo4() {
		return jobReferNo4;
	}

	public void setJobReferNo4(String jobReferNo4) {
		this.jobReferNo4 = jobReferNo4;
	}

	public String getJobReferNo5() {
		return jobReferNo5;
	}

	public void setJobReferNo5(String jobReferNo5) {
		this.jobReferNo5 = jobReferNo5;
	}

	public void setJobReferNos(String[] jobReferNos) {
		this.jobReferNos = jobReferNos;
	}

	public Date getNextFireDate() {
		return nextFireDate;
	}

	public void setNextFireDate(Date nextFireDate) {
		this.nextFireDate = nextFireDate;
	}

	public String toString() {
		return "Func:" + this.jobFuncType + " Sub Func:" + this.jobFuncSubType
				+ " Job Id:" + this.jobId + " Refer No:" + this.jobReferNo;
	}

	public String[] getJobReferNos() {
		jobReferNos = new String[5];
		jobReferNos[0] = StringUtils.trimToEmpty(jobReferNo);
		jobReferNos[1] = StringUtils.trimToEmpty(jobReferNo2);
		jobReferNos[2] = StringUtils.trimToEmpty(jobReferNo3);
		jobReferNos[3] = StringUtils.trimToEmpty(jobReferNo4);
		jobReferNos[4] = StringUtils.trimToEmpty(jobReferNo5);
		return jobReferNos;
	}
}
