package com.rapid.j2ee.framework.batchjob.service;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.rapid.j2ee.framework.batchjob.domain.SystemBatchJobTask;
import com.rapid.j2ee.framework.mvc.service.BusinessService;

public interface RapidSystemBatchJobTasksService extends BusinessService {

	/**
	 * 添加需要跟踪的BatchJob任务信息
	 * 
	 * 通过SystemDictionary "SYSTEM_BATCH_JOB" 和 "SYSTEM_BATCH_JOB_FIRE"
	 * 查询所有的BatchJob任务，同时使用ClassType来加载仅仅用于
	 * 
	 * SystemJobLog中FUNCTYPE指定的Job类型
	 * 
	 * 
	 * @param SystemBatchJobTask
	 *            系统JOB日志 通常需要提供FUNCTYPE
	 * 
	 * @param Delete
	 *            Log 是否重新添加日志
	 * 
	 */
	public void addSystemBatchJobTasksBySystemDictionaryConfigure(
			SystemBatchJobTask systemJobLog, boolean deleteLog,
			Object... parameters);

	/***************************************************************************
	 * 添加需要跟踪的BatchJob任务信息
	 * 
	 * @param SystemBatchJobTask
	 *            系统JOB日志 通常需要提供FUNCTYPE
	 * 
	 * @param Delete
	 *            Log 是否重新添加日志
	 */
	public void addSystemBatchJobTask(SystemBatchJobTask systemJobLog);

	/**
	 * 更新系统JOB状态为 Ready状态，可以上传了
	 * 
	 * @param Batch
	 *            Job Task Id 系统JOB日志ID
	 */
	public void updateSystemBatchJobTaskForReady(Class funcTypeClazz,
			String subFuncType, String... referNos);

	/**
	 * 更新：状态为PCNG并(系统时间-任务开始时间>设置的时间)，更新状态为UNPC
	 * 
	 * @param funcType
	 * @return
	 */
	public void updateSystemBatchJobTaskForProcessing(@Param("time")
	String time);

	/**
	 * 更新系统JOB状态为 Cancel状态，任务标识为终结，不必处理
	 * 
	 * @param Batch
	 *            Job Task Id 系统JOB日志ID
	 */
	public void updateSystemBatchJobTaskForCancel(Class funcTypeClazz,
			String subFuncType, String... referNos);

	/**
	 * 查询非成功执行的job数
	 * 
	 * @param
	 * @return
	 */
	public int getSystemBatchJobTaskCountForUnSuccess(Class funcTypeClazz,
			String[] funcSubTypes, String[] referNos);

}
