package com.rapid.j2ee.framework.batchjob.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.rapid.j2ee.framework.batchjob.constants.RapidSystemBatchJobTaskConstants;
import com.rapid.j2ee.framework.batchjob.constants.RapidSystemBatchJobTaskStatus;
import com.rapid.j2ee.framework.batchjob.domain.SystemBatchJobTask;
import com.rapid.j2ee.framework.batchjob.persistence.RapidSystemBatchJobTaskMapper;
import com.rapid.j2ee.framework.core.exception.ApplicationException;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.MediumSessionMapperOperations;


@Transactional(noRollbackFor = ApplicationException.class, value = "RapidSystemBatchJob")
public class RapidSystemBatchJobTasksServiceImpl implements
		RapidSystemBatchJobTasksService {

	/*
	 * (non-Javadoc)
	 * 
	 * @seecom.anbang.galaxy.jove.batchjob.system.service.
	 * SystemBatchJobTasksMaintenanceService
	 * #addSystemBatchJobTasksBySystemDictionaryConfigure
	 * (com.anbang.galaxy.jove.batchjob.system.domain.SystemBatchJobTask,
	 * boolean)
	 */
	public void addSystemBatchJobTasksBySystemDictionaryConfigure(
			SystemBatchJobTask systemJobLog, boolean deleteLog,
			Object... parameters) {

		if (deleteLog) {
			systemBatchJobTaskMaintenanceMapper.deleteSystemJobLogByFuncType(
					systemJobLog.getJobFuncType(), systemJobLog
							.getJobReferNos());
		}

		mediumSessionMapperOperations.insertList(systemBatchJobTaskFireSchedule
				.getSystemBatchJobTasksScheduled(systemJobLog, parameters));

	}

	public void addSystemBatchJobTask(SystemBatchJobTask systemJobLog) {

		systemJobLog = (SystemBatchJobTask) mediumSessionMapperOperations
				.queryOneWithNull(systemJobLog);
		// 如果查询结果为空、状态为完成或取消时insert
		if (TypeChecker.isEmptyObject(systemJobLog)
				|| RapidSystemBatchJobTaskStatus.Success.getStatus().equals(
						systemJobLog.getJobStatus())
				|| RapidSystemBatchJobTaskStatus.Cancel.getStatus().equals(
						systemJobLog.getJobStatus())) {

			mediumSessionMapperOperations.insert(systemJobLog);

		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seecom.anbang.galaxy.jove.batchjob.system.service.
	 * SystemBatchJobTasksMaintenanceService
	 * #updateSystemBatchJobTaskForReady(java.lang.String, java.lang.String,
	 * java.lang.String[])
	 */
	public void updateSystemBatchJobTaskForReady(Class funcTypeClazz,
			String subFuncType, String... referNos) {
		systemBatchJobTaskMaintenanceMapper.updateSystemBatchJobTaskForReady(
				funcTypeClazz.getSimpleName(), subFuncType, referNos);
	}

	public void updateSystemBatchJobTaskForProcessing(String time) {

		systemBatchJobTaskMaintenanceMapper
				.updateSystemBatchJobTaskForProcessing(time);
	}

	public void updateSystemBatchJobTaskForCancel(Class funcTypeClazz,
			String subFuncType, String... referNos) {

		systemBatchJobTaskMaintenanceMapper.updateSystemBatchJobTaskForCancel(
				funcTypeClazz.getSimpleName(), subFuncType, referNos);

	}

	public int getSystemBatchJobTaskCountForUnSuccess(Class funcTypeClazz,
			String[] funcSubTypes, String[] referNos) {

		return systemBatchJobTaskMaintenanceMapper
				.getSystemBatchJobTaskCountForUnSuccess(funcTypeClazz
						.getSimpleName(), funcSubTypes, referNos);
	}

	@Autowired
	@Qualifier("RapidBatchJob_SessionMapper")
	private MediumSessionMapperOperations mediumSessionMapperOperations;

	@Autowired
	private RapidSystemBatchJobTaskMapper systemBatchJobTaskMaintenanceMapper;

	@Autowired
	private SystemBatchJobTaskFireSchedule systemBatchJobTaskFireSchedule;

}
