package com.rapid.j2ee.framework.bean.assemble;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.bean.assemble.annotation.FieldProviderLinkage;
import com.rapid.j2ee.framework.bean.assemble.annotation.Provider;
import com.rapid.j2ee.framework.core.collections.HashMapAsKeyIgnoreCase;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class AbstractBeanFieldValueAssembleFactory implements
		InitializingBean, BeanAssembleFactory {

	public void assemble(Object bean) {

		if (TypeChecker.isNull(bean)) {
			return;
		}

		for (Field field : ClassUtils.getAllFieldsAsClassByAnnotation(bean
				.getClass(), FieldProviderLinkage.class)) {

			setFieldValue(bean, field, field
					.getAnnotation(FieldProviderLinkage.class));
		}

	}

	protected void setFieldValue(Object bean, Field field,
			FieldProviderLinkage fieldProviderLinkage) {

		BeanFieldValueProvider beanFieldProvider = beanFieldValueProviderMapper
				.get(fieldProviderLinkage.provider().toLowerCase());

		Assert.notNull(beanFieldProvider,
				"Please provide a bean field value provider for "
						+ fieldProviderLinkage.provider());

		beanFieldProvider.setObjectValue(bean, fieldProviderLinkage, field);

	}

	public void afterPropertiesSet() throws Exception {

		this.doValidatePropertiesSet();

		for (BeanFieldValueProvider beanFieldValueProvider : beanFieldValueProviders) {
			beanFieldValueProviderMapper.put(beanFieldValueProvider.getClass()
					.getAnnotation(Provider.class).value().toLowerCase(),
					beanFieldValueProvider);
		}
	}

	private void doValidatePropertiesSet() {
		for (BeanFieldValueProvider beanFieldValueProvider : beanFieldValueProviders) {
			if (!beanFieldValueProvider.getClass().isAnnotationPresent(
					Provider.class)) {
				throw new IllegalArgumentException(
						"Please provide a provider name annoation [Provider] for "
								+ beanFieldValueProvider.getClass().getName());
			}
		}
	}

	@Autowired(required = false)
	private List<BeanFieldValueProvider> beanFieldValueProviders = new ArrayList<BeanFieldValueProvider>();

	private Map<String, BeanFieldValueProvider> beanFieldValueProviderMapper = new HashMapAsKeyIgnoreCase<BeanFieldValueProvider>();

}
