package com.rapid.j2ee.framework.bean.assemble;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.bean.assemble.annotation.FieldProviderLinkage;
import com.rapid.j2ee.framework.core.collections.SortHashMap;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.MapUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.Callable;

public abstract class AbstractBeanFieldValueProvider implements
		BeanFieldValueProvider {

	public void setObjectValue(Object bean,
			FieldProviderLinkage fieldProviderLinkage, Field field) {

		try {
			if (TypeChecker.isNull(bean)) {
				return;
			}
			Object object = this.getFieldValueAssembled(bean,
					fieldProviderLinkage, field, this
							.getFieldProviderLinkageParameters(
									fieldProviderLinkage, bean));
			if (fieldProviderLinkage.isNotNull()) {
				Assert.notNull(object,
						"Please provide value [not null] for parameters["
								+ fieldProviderLinkage.parameters()
								+ "] Assemble Handler Name["
								+ fieldProviderLinkage.provider()
								+ " at field [" + field.getName() + "]");
			}
			InvokeUtils.setField(bean, field.getName(), object);
		} catch (Throwable e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	private synchronized SortHashMap getFieldProviderLinkageParameters(
			FieldProviderLinkage fieldProviderLinkage, Object bean) {

		getLinkageParameterGroupKeyCallables();

		SortHashMap map = StringUtils.splitSortHashMapByGroupKey(
				fieldProviderLinkage.parameters(), ";", ":");

		return (SortHashMap) MapUtils.resolveMap(map,
				getLinkageParameterGroupKeyCallables(), bean);
	}

	protected List<Callable<String>> getLinkageParameterGroupKeyCallables() {

		if (TypeChecker.isEmpty(callables)) {
			callables.add(Callable.UPPERCASE);
		}

		return callables;
	}

	protected abstract Object getFieldValueAssembled(Object bean,
			FieldProviderLinkage fieldProviderLinkage, Field field,
			Map<String, String> parameters) throws Throwable;

	protected List<Callable<String>> callables = new ArrayList<Callable<String>>(
			5);

}
