package com.rapid.j2ee.framework.bean.assemble.plugin;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.bean.assemble.AbstractBeanFieldValueProvider;
import com.rapid.j2ee.framework.bean.assemble.annotation.FieldProviderLinkage;
import com.rapid.j2ee.framework.bean.assemble.annotation.Provider;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.Callable;

@Component
@Provider("GenericServiceFacadeBeanFieldProvider")
public class GenericServiceFacadeBeanFieldValueProvider extends
		AbstractBeanFieldValueProvider implements ApplicationContextAware {

	@Override
	protected Object getFieldValueAssembled(Object bean,
			FieldProviderLinkage fieldProviderLinkage, Field field,
			Map<String, String> parameters) throws Throwable {

		Assert.hasLength(parameters.get(Service_Class_Type));

		Assert.hasLength(parameters.get(Service_Method));

		Class businessServiceClass = ClassUtils.forName(parameters
				.get(Service_Class_Type));

		Method method = InvokeUtils.findMethod(businessServiceClass, parameters
				.get(Service_Method));

		Assert.notNull(method);

		Object businessService = applicationContext
				.getBean(businessServiceClass);

		if (!TypeChecker.isEmpty(method.getParameterTypes())) {

			if (method.getParameterTypes().length == 1
					&& method.getParameterTypes()[0] == Map.class) {

				return method.invoke(businessService,
						new Object[] { parameters });
			}

			throw new UnsupportedOperationException("Method:"
					+ method.getName()
					+ " has error parameters! Only Support Map or Null");
		}

		return method.invoke(businessService, ObjectUtils.EMPTY_OBJECT_ARRAYS);
	}

	protected List<Callable<String>> getLinkageParameterGroupKeyCallables() {

		return callables;
	}

	public void setApplicationContext(ApplicationContext applicationContext)
			throws BeansException {
		this.applicationContext = applicationContext;

	}

	private static final String Service_Class_Type = "SERVICE_TYPE";

	private static final String Service_Method = "SERVICE_METHOD";

	private ApplicationContext applicationContext;
}
