package com.rapid.j2ee.framework.bean.dictionary;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.itextpdf.text.log.SysoCounter;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.memorycache.BusinessServiceCache;
import com.rapid.j2ee.framework.core.memorycache.BusinessServiceCacheSelector;
import com.rapid.j2ee.framework.core.memorycache.strategy.CacheStrategy.Strategy;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.MapUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.Callable;
import com.rapid.j2ee.framework.mvc.security.domain.WebUser;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;

public abstract class AbstractDictionaryTranslationResolver implements
		DictionaryTranslationResolver {

	public Object translate(Map<String, String> parameters, Object bean,
			String fieldName) {

		Object fieldValue = null;

		try {

			resolveParameters(parameters, bean);

			fieldValue = BeanDictionaryFieldsResolvableTranslator
					.getObjectValueWithTempValueThreadLocaleChecking(InvokeUtils
							.getFieldValue(bean, fieldName));

			if (isVoidNullOrEmpty(fieldValue)) {
				return StringUtils.trimToEmpty(parameters
						.get(Translation_Default_Value_Key));
			}

			return resolveValue(parameters, doTranslate(
					MvcSecurityActionContextUtils.getWebUser(), parameters,
					bean, fieldName, fieldValue, StringUtils
							.trimToEmpty(parameters
									.get(Translation_Default_Unit_Key))));
		} catch (Exception e) {

			logger.error("translate Error! Resolver ======== "
					+ this.getClass().getName() + " parameters======="
					+ parameters, e);

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	protected Object resolveValue(Map<String, String> parameters, Object value) {

		return value;
	}

	private Object doTranslate(WebUser webUser, Map<String, String> paramters,
			Object bean, String fieldName, Object fieldValue, String unit) {

		if (!MapUtils.containsKey(paramters, EMPTY_OCCUPIED_PARAMETER_KEYS[0])) {
			return this.doTranslateWithPossibleCachedCheck(webUser, paramters,
					bean, fieldName, fieldValue, unit);
		}

		String separator = (String) MapUtils.getValueByIngoreCaseKey(paramters,
				EMPTY_OCCUPIED_PARAMETER_KEYS[0]);

		String[] fieldValues = StringUtils.splitBySeparator(
				(String) fieldValue, separator);

		List<String> fieldValueText = new ArrayList<String>(fieldValues.length);

		for (String fieldValueTemp : fieldValues) {

			fieldValueText.add((String) this
					.doTranslateWithPossibleCachedCheck(webUser, paramters,
							bean, fieldName, fieldValueTemp, unit));
		}

		if (!MapUtils.containsKey(paramters, EMPTY_OCCUPIED_PARAMETER_KEYS[1])) {
			return StringUtils.getStringBunch(fieldValueText, separator);
		}

		return StringUtils.getStringBunch(fieldValueText, (String) MapUtils
				.getValueByIngoreCaseKey(paramters,
						EMPTY_OCCUPIED_PARAMETER_KEYS[1]));

	}

	private Object doTranslateWithPossibleCachedCheck(WebUser webUser,
			Map<String, String> paramters, Object bean, String fieldName,
			Object fieldValue, String unit) {

		if (!this.isCachedRequired()) {
			return this.translate(webUser, paramters, bean, fieldName,
					fieldValue, unit);
		}

		Assert
				.notNull(businessServiceCacheSelector,
						"Please provide a BusinessServiceCacheSelector implementation!");

		BusinessServiceCache businessServiceCache = businessServiceCacheSelector
				.getBusinessServiceCache(this.getCacheStrategy());

		String key = getCachedKey(getResolverName(), paramters, fieldValue);

		if (!businessServiceCache.hasCachedValue(key)) {

			Object tranValue = this.translate(webUser, paramters, bean,
					fieldName, fieldValue, unit);

			return businessServiceCache.storeValue(key, tranValue);
		}

		return businessServiceCache.getValueCached(key);

	}

	private synchronized void resolveParameters(Map<String, String> paramters,
			Object bean) {

		MapUtils.resolveMap(paramters, getLinkageParameterGroupKeyCallables(),
				bean);

		for (String key : paramters.keySet()) {

			resolveParameterValueByKey(paramters, key);

		}

	}

	private void resolveParameterValueByKey(Map<String, String> paramters,
			String key) {

		paramters.put(key, resolveParameterValue(paramters.get(key)));
	}

	private static final String[] EMPTY_OCCUPIED_PARAMETER_KEYS = new String[] {
			"Separator", "ReplaceSeparator" };

	private String resolveParameterValue(String value) {

		value = StringUtils.trimToEmpty(value);

		if ("comma".equalsIgnoreCase(value)) {
			return ",";
		}

		int count = StringUtils.countsIngoreCaseByTarget(value, "blank");

		if (count > 0) {
			return StringUtils.repeatChars(" ", count);
		}

		return value;
	}

	protected abstract Object translate(WebUser webUser,
			Map<String, String> paramters, Object bean, String fieldName,
			Object fieldValue, String unit);

	protected boolean isVoidNullOrEmpty(Object fieldValue) {
		return TypeChecker.isNull(fieldValue)
				|| ((fieldValue instanceof String && TypeChecker
						.isEmpty((String) fieldValue)));
	}

	public Strategy getCacheStrategy() {

		return Strategy.NoCache;
	}

	private boolean isCachedRequired() {

		return this.getCacheStrategy() != Strategy.NoCache;
	}

	private static String getCachedKey(String resolverName,
			Map<String, String> paramters, Object fieldValue) {
		return "DictionaryTranslationResolver." + resolverName + "|"
				+ ObjectAnalyzer.toString(paramters) + "|" + fieldValue;
	}

	protected List<Callable<String>> getLinkageParameterGroupKeyCallables() {

		if (TypeChecker.isEmpty(callables)) {
			callables.add(Callable.STACKVALUE);
		}

		return callables;
	}

	@Autowired(required = false)
	private BusinessServiceCacheSelector businessServiceCacheSelector;

	protected List<Callable<String>> callables = new ArrayList<Callable<String>>(
			5);

	protected Log logger = LogFactory.getLog(this.getClass());
}
