package com.rapid.j2ee.framework.bean.dictionary.aop;

import java.lang.reflect.Field;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;

import com.rapid.j2ee.framework.bean.dictionary.BeanDictionaryFieldsResolvableTranslator;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class TranslationResolvableAopAroundAdivice {

	private static ThreadLocal<Boolean> closeResolver = new ThreadLocal<Boolean>();

	protected Log logger = LogFactory.getLog(this.getClass());

	public static void setCloseTranslationResolver() {

		closeResolver.set(Boolean.TRUE);
	}

	public static void removeCloseTranslationResolver() {

		closeResolver.remove();
	}

	public static boolean isTranslationResolverClosed() {
		return closeResolver.get() != null
				&& closeResolver.get().booleanValue();
	}

	public Object translate(ProceedingJoinPoint point) throws Throwable {

		MethodSignature methodSignature = (MethodSignature) point
				.getSignature();

		Object value = point.proceed();

		if (TypeChecker.isNull(value)) {
			return value;
		}

		if (isTranslationResolverClosed()) {

			return value;
		}

		MethodReturnTranslationResolver methodReturnTranslationResolver = methodSignature
				.getMethod().getAnnotation(
						MethodReturnTranslationResolver.class);

		if (TypeChecker.isNull(methodReturnTranslationResolver)) {
			return value;
		}

		logger
				.info("The translation process [TranslationResolvableAopAroundAdivice.translate] has worked at "
						+ methodSignature.getName()
						+ "/"
						+ point.getTarget().getClass().getSimpleName());

		translateWithReturnType(methodReturnTranslationResolver, value);

		return value;
	}

	private void translateWithReturnType(
			MethodReturnTranslationResolver methodReturnTranslationResolver,
			Object value) throws Throwable {

		if (TypeChecker.isNull(value)) {
			return;
		}

		this.doTranslateValueByReturnType(
				beanDictionaryFieldsResolvableTranslator,
				methodReturnTranslationResolver, value.getClass(), value);

	}

	protected abstract void doTranslateValueByReturnType(
			BeanDictionaryFieldsResolvableTranslator beanDictionaryFieldsResolvableTranslator,
			MethodReturnTranslationResolver methodReturnTranslationResolver,
			Class valueClazz, Object value) throws Throwable;

	@Autowired
	private BeanDictionaryFieldsResolvableTranslator beanDictionaryFieldsResolvableTranslator;

}
