package com.rapid.j2ee.framework.bean.dictionary.item;

import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public class DictionaryItemBean implements DictionaryItem,
		Comparable<DictionaryItemBean> {

	@XmlFieldAttribute
	private String optionText;

	@XmlFieldAttribute
	private String optionValue;

	@XmlFieldAttribute
	private String parentOptionValue;

	@XmlFieldAttribute
	private String optionPaths;

	private int orderSeqNo = 0;

	public DictionaryItemBean(String optionValue, String optionText) {
		this.optionValue = optionValue;
		this.optionText = optionText;
	}

	public DictionaryItemBean(String optionValue, String optionText,
			String parentOptionValue) {
		this.optionValue = optionValue;
		this.optionText = optionText;
		this.parentOptionValue = parentOptionValue;
	}

	public String toString() {
		return "parentOptionValue:" + this.parentOptionValue + " optionValue:"
				+ this.optionValue + " optionText:" + this.optionText;
	}

	public String getOptionText() {
		return optionText;
	}

	public void setOptionText(String optionText) {
		this.optionText = optionText;
	}

	public String getOptionValue() {
		return optionValue;
	}

	public void setOptionValue(String optionValue) {
		this.optionValue = optionValue;
	}

	public String getParentOptionValue() {
		return parentOptionValue;
	}

	public void setParentOptionValue(String parentOptionValue) {
		this.parentOptionValue = parentOptionValue;
	}

	public String getOptionPaths() {
		return optionPaths;
	}

	public DictionaryItem setOptionPaths(String optionPaths) {
		this.optionPaths = optionPaths;
		return this;
	}

	@Override
	public boolean equals(Object obj) {

		if (this == obj) {
			return true;
		}

		DictionaryItemBean bean = (DictionaryItemBean) obj;

		return StringUtils.getStringBunchUsingUnderlineAsSeparator(
				this.optionValue, this.parentOptionValue).equalsIgnoreCase(
				StringUtils.getStringBunchUsingUnderlineAsSeparator(
						bean.optionValue, bean.parentOptionValue));

	}

	@Override
	public int hashCode() {

		return StringUtils.getStringBunchUsingUnderlineAsSeparator(
				this.optionValue, this.parentOptionValue).hashCode() * 3 + 17;
	}

	public int getOrderSeqNo() {
		return orderSeqNo;
	}

	public void setOrderSeqNo(int orderSeqNo) {
		this.orderSeqNo = orderSeqNo;
	}

	public int compareTo(DictionaryItemBean defaultCodeTableBean) {
		if (defaultCodeTableBean == this) {
			return 0;
		}

		return this.orderSeqNo - defaultCodeTableBean.orderSeqNo;
	}

	private static final long serialVersionUID = 1L;
}
