package com.rapid.j2ee.framework.bean.duplicator;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.exception.ApplicationException;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.MapUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.OperationResult;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;

public class GeneralDuplicateTransactionValidator implements
		DuplicateTransactionValidator, InitializingBean {

	public boolean isFurtherDuplicatedCheckingNeeded(Object bean) {

		Assert.notNull(bean);

		Field[] currentFields = ClassUtils.getAllFieldsAsClassByAnnotation(bean
				.getClass(), DuplicateAttribute.class);

		Assert.noNullElements(currentFields,
				"Please setup DuplicateAttribute annotation for checked target class "
						+ bean.getClass().getSimpleName() + "!");

		String enrollFormValue = StringUtils.getStringBunchByObjectFieldNames(
				bean, "!~!", currentFields);

		String originalFormValue = getOrignalFieldValues(currentFields);
		Logger
				.info("---------------isFurtherDuplicatedCheckingNeeded--------------------------");
		Logger.info("DuplicateAttribute Field/Methods:"
				+ StringUtils.printArrays(currentFields));

		Logger.info("Duplicated Check Enrolled Form Value:" + enrollFormValue);

		Logger.info("Original Form Value:" + originalFormValue);

		return !enrollFormValue.equalsIgnoreCase(originalFormValue);

	}

	public void validateThrowAppExpForDuplicate(Object bean,
			OperationResult operationResult, Object... arguments) {

		if (!isFurtherDuplicatedCheckingNeeded(bean)) {
			return;
		}

		if (getDuplicateValidationHandler(bean).isDuplicatedRecord(bean)) {
			throw new ApplicationException(operationResult)
					.setResultMessageArguments(arguments);
		}

	}

	public void validateThrowAppExpForDuplicate(Object bean,
			Object... arguments) {

		validateThrowAppExpForDuplicate(
				bean,
				OperationResultConstants.FAILED_DATABASE_BUSINESS_DUPLICATION_ERROR,
				arguments);
	}

	public void validateThrowAppExpForDuplicate(Object bean) {
		validateThrowAppExpForDuplicate(bean, this
				.getDuplicatedFieldValues(bean));
	}

	private Object[] getDuplicatedFieldValues(Object bean) {

		Field[] currentFields = ClassUtils.getAllFieldsAsClassByAnnotation(bean
				.getClass(), DuplicateAttribute.class);

		List<Object> fieldValues = new ArrayList<Object>(currentFields.length);

		for (Field field : currentFields) {

			fieldValues.add(BeanUtils.getPropertyObject(bean, field.getName()));
		}

		return fieldValues.toArray(new Object[currentFields.length]);
	}

	private String getOrignalFieldValues(Field[] currentFields) {

		List<String> oringalFieldValue = new ArrayList<String>(
				currentFields.length);

		for (Field field : currentFields) {

			oringalFieldValue.add(getParameterValue(field, field
					.getAnnotation(DuplicateAttribute.class)));

		}

		return StringUtils.getStringBunch(oringalFieldValue, "!~!");

	}

	private String getParameterValue(Field field,
			DuplicateAttribute duplicateAttribute) {

		for (String name : StringUtils.splitBySeparator(duplicateAttribute
				.value(), ",")) {

			String parameterName = name + duplicateAttribute.join()
					+ field.getName();

			if (TypeChecker.isEmpty(duplicateAttribute.join())) {
				parameterName = name
						+ StringUtils.upperStartChar(field.getName());
			}

			String value = _getParameterValue(parameterName);

			if (!TypeChecker.isEmpty(value)) {
				return value;
			}
		}

		return "";
	}

	private String _getParameterValue(String name) {

		Object paramaterValues = ActionContext.getContext().getParameters()
				.get(name);

		if (TypeChecker.isNull(paramaterValues)) {
			return "";
		}

		if (paramaterValues instanceof String[]) {
			return StringUtils.getStringBunch((String[]) paramaterValues, ",");
		}

		return String.valueOf(paramaterValues).trim();
	}

	private DuplicateValidationHandler getDuplicateValidationHandler(Object bean) {

		Class beanClass = bean.getClass();

		return duplicateValidationHandlerClassMaper.containsKey(beanClass) ? duplicateValidationHandlerClassMaper
				.get(beanClass)
				: duplicateValidationHandlerClassMaper.get(Object.class);
	}

	public void afterPropertiesSet() throws Exception {
		for (DuplicateValidationHandler duplicateValidationHandler : duplicateValidationHandlers) {
			DuplicateValidationBeanMatcher duplicateValidationBeanMatcher = duplicateValidationHandler
					.getClass().getAnnotation(
							DuplicateValidationBeanMatcher.class);
			Assert
					.notNull(
							duplicateValidationBeanMatcher,
							"Please provide a DuplicateValidationHandler DuplicateValidationBeanMatcher for "
									+ duplicateValidationHandler.getClass());
			duplicateValidationHandlerClassMaper.put(
					duplicateValidationBeanMatcher.value(),
					duplicateValidationHandler);
		}
		Logger
				.info("--------------------------------------Register DuplicateValidationHandlerClassMaper-------------------------------------------");
		Logger.info(duplicateValidationHandlerClassMaper);
		Logger
				.info("--------------------------------------------------------------------------------------------------------------------------------------------------------");
	}

	@Autowired
	private List<DuplicateValidationHandler> duplicateValidationHandlers = new ArrayList<DuplicateValidationHandler>();

	private Map<Class, DuplicateValidationHandler> duplicateValidationHandlerClassMaper = new HashMap<Class, DuplicateValidationHandler>();

	private static Log Logger = LogFactory
			.getLog(GeneralDuplicateTransactionValidator.class);

}
