package com.rapid.j2ee.framework.bean.duplicator;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.orm.medium.MediumSessionMapperOperations;
import com.rapid.j2ee.framework.orm.medium.bean.BaseMediumBean;

@DuplicateValidationBeanMatcher(Object.class)
public class MediumSessionDuplicateValidationHandler implements
		DuplicateValidationHandler {

	public boolean isDuplicatedRecord(Object bean) {

		Object beanTemp = ConstructorUtils.newInstance(bean.getClass());

		if (beanTemp instanceof BaseMediumBean) {
			((BaseMediumBean) beanTemp).clearQueryValues();
		}

		BeanUtils.copy(bean, beanTemp, DuplicateAttribute.class);
		BeanUtils.copy(bean, beanTemp, DuplicateValueAttribute.class);

		return mediumSessionMapperOperations.existsForQuery(beanTemp);
	}

	public void setMediumSessionMapperOperations(
			MediumSessionMapperOperations mediumSessionMapperOperations) {
		this.mediumSessionMapperOperations = mediumSessionMapperOperations;
	}

	private MediumSessionMapperOperations mediumSessionMapperOperations;

}
