package com.rapid.j2ee.framework.bean.requestbeans;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.rapid.j2ee.framework.bean.requestbeans.annotation.RequestBeans;
import com.rapid.j2ee.framework.bean.requestbeans.annotation.RequestBeansConfigurer;
import com.rapid.j2ee.framework.bean.requestbeans.annotation.RequestBeansValueBunchConfigurer;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class AbstractRequestBeansAssembleFactory implements
		RequestBeansAssembleFactory {

	public void resolveBeans(Object modelBean, HttpServletRequest request) {

		if (TypeChecker.isNull(modelBean)
				|| !modelBean.getClass()
						.isAnnotationPresent(RequestBeans.class)) {
			return;
		}

		this.doResolveBeanForRequestBeansConfigurer(modelBean, request);

		this.doResolveBeanForRequestBeansValueBunchConfigurer(modelBean,
				request);

	}

	private void doResolveBeanForRequestBeansConfigurer(Object modelBean,
			HttpServletRequest request) {

		for (Field field : ClassUtils.getAllFieldsAsClassByAnnotation(modelBean
				.getClass(), RequestBeansConfigurer.class)) {

			if (!this.hasRequestBeanParametersForRequestBeansConfigurer(field,
					request)) {
				continue;
			}

			InvokeUtils.setField(modelBean, field, this
					.getRequestBeansForRequestBeansConfigurer(modelBean, field,
							field.getAnnotation(RequestBeansConfigurer.class),
							request));
		}

	}

	private void doResolveBeanForRequestBeansValueBunchConfigurer(
			Object modelBean, HttpServletRequest request) {

		for (Field field : ClassUtils.getAllFieldsAsClassByAnnotation(modelBean
				.getClass(), RequestBeansValueBunchConfigurer.class)) {

			if (!this
					.hasRequestBeanParametersForRequestBeansValueBunchConfigurer(
							field, request)) {
				continue;
			}

			InvokeUtils
					.setField(
							modelBean,
							field,
							this
									.getRequestBeansForRequestBeansValueBunchConfigurer(
											modelBean,
											field,
											field
													.getAnnotation(RequestBeansValueBunchConfigurer.class),
											request));
		}
	}

	private boolean hasRequestBeanParametersForRequestBeansConfigurer(
			Field field, HttpServletRequest request) {

		RequestBeansConfigurer requestBeansConfigurer = field
				.getAnnotation(RequestBeansConfigurer.class);

		return !TypeChecker.isEmpty(this.getParameterValuesByName(request,
				requestBeansConfigurer.requestBeanNames()[0]));

	}

	private boolean hasRequestBeanParametersForRequestBeansValueBunchConfigurer(
			Field field, HttpServletRequest request) {

		RequestBeansValueBunchConfigurer requestBeansConfigurer = field
				.getAnnotation(RequestBeansValueBunchConfigurer.class);

		return !TypeChecker.isEmpty(this.getParameterValuesByName(request,
				requestBeansConfigurer.targetResourceName()));

	}

	private Object getRequestBeansForRequestBeansConfigurer(Object modelBean,
			Field field, RequestBeansConfigurer requestBeansConfigurer,
			HttpServletRequest request) {

		String[] fieldValues = this.getParameterValuesByName(request,
				requestBeansConfigurer.requestBeanNames()[0]);

		if (TypeChecker.isEmpty(fieldValues)) {

			if (Collection.class.isAssignableFrom(field.getType())) {
				return ObjectUtils.EMPTY_LIST;
			}

			return modelBean;
		}

		List beans = new ArrayList(fieldValues.length);

		for (int i = 0, j = fieldValues.length; i < j; i++) {

			Object bean = ConstructorUtils.newInstance(requestBeansConfigurer
					.targetBeanClass());

			for (String fieldName : requestBeansConfigurer.requestBeanNames()) {

				InvokeUtils.setSetterMethodOrField(bean, fieldName, this
						.getParameterValuesByName(request, fieldName, i));

			}

			ConstructorUtils.newCacheInstance(
					requestBeansConfigurer.resolveClass()).resolve(modelBean,
					bean, request);

			beans.add(bean);
		}

		if (Collection.class.isAssignableFrom(field.getType())) {
			return beans;
		}

		return TypeChecker.isEmpty(beans) ? null : beans.get(0);
	}

	private Object getRequestBeansForRequestBeansValueBunchConfigurer(
			Object modelBean, Field field,
			RequestBeansValueBunchConfigurer annotation,
			HttpServletRequest request) {

		String[] fieldValues = this.getParameterValuesByName(request,
				annotation.targetResourceName());

		if (TypeChecker.isEmpty(fieldValues)) {

			if (Collection.class.isAssignableFrom(field.getType())) {
				return ObjectUtils.EMPTY_LIST;
			}

			return modelBean;
		}

		List beans = new ArrayList(fieldValues.length);

		for (String fieldValue : fieldValues) {

			if (TypeChecker.isEmpty(fieldValue)) {
				continue;
			}

			Object bean = ConstructorUtils.newInstance(annotation
					.targetBeanClass());

			String[] beanFieldValues = StringUtils.splitBySeparator(fieldValue,
					annotation.separator());

			for (int i = 0; i < beanFieldValues.length; i++) {

				InvokeUtils.setSetterMethodOrField(bean, annotation
						.fieldNames()[i], beanFieldValues[i]);

			}

			ConstructorUtils.newCacheInstance(annotation.resolveClass())
					.resolve(modelBean, bean, request);

			beans.add(bean);

		}

		if (Collection.class.isAssignableFrom(field.getType())) {
			return beans;
		}

		return TypeChecker.isEmpty(beans) ? null : beans.get(0);
	}

	protected abstract String[] getParameterValuesByName(
			HttpServletRequest request, String name);

	protected String getParameterValuesByName(HttpServletRequest request,
			String name, int index) {

		String[] values = this.getParameterValuesByName(request, name);

		if (values.length == 1) {
			return values[0];
		}

		return this.getParameterValuesByName(request, name)[index];
	}

}
