package com.rapid.j2ee.framework.build;

import java.io.File;
import java.util.Properties;

import com.rapid.j2ee.framework.core.utils.FileUtils;

public class BuildFrameworkResourcesWebApp {

	private String resourceFolder;

	private Properties properties;

	private String fileFromName;

	private String fileToName;

	public BuildFrameworkResourcesWebApp(String resourceFolder,
			String fileFromName, String fileToName, Properties properties) {
		this.resourceFolder = resourceFolder;
		this.properties = properties;
		this.fileFromName = fileFromName;
		this.fileToName = fileToName;
	}

	public void build() {

		for (File file : FileUtils.listFiles(new File(this.resourceFolder))) {

			resolve(file);
		}
	}

	private void resolve(File file) {

		BuildResourceName buildResourceName = new BuildResourceName(file,
				fileFromName, fileToName);

		File targetFile = buildResourceName.rename();

		for (Object key : properties.keySet()) {

			new BuildResourceContentResolve(targetFile, String.valueOf(key),
					properties.getProperty(String.valueOf(key))).resolve();
		}

	}

	public static void main(String[] args) {
		Properties contentChanges = new Properties();
		// contentChanges.setProperty("chinaetax", "frameworkdemo");
		// contentChanges.setProperty("ChinaeTax", "FrameworkDemo");
		contentChanges.setProperty("_frameworkdemo_", "_core_");

		
		BuildFrameworkResourcesWebApp buildFrameworkResourcesWebApp = new BuildFrameworkResourcesWebApp(
				"G:\\Workspace(JohnHao)\\ABIT\\eMap_Workspace\\GalaxyCore(RF)\\src\\main\\resources",
				"frameworkdemo", "core", contentChanges);

		buildFrameworkResourcesWebApp.build();
	}
}
