package com.rapid.j2ee.framework.build;

import java.io.File;

import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.io.file.FileReader;
import com.rapid.j2ee.framework.core.io.file.FileWriter;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public class BuildResourceContentResolve {

	private File resourceFile;

	private String fromName;

	private String toName;

	public BuildResourceContentResolve(File resourceFile, String fromName,
			String toName) {
		this.resourceFile = resourceFile;
		this.fromName = fromName;
		this.toName = toName;
	}

	public void resolve() {

		this.rename(this.replaceContent());

	}

	private void rename(File tmp) {

		FileUtils.delete(this.resourceFile.getAbsolutePath());

		tmp.renameTo(resourceFile);
	}

	private File replaceContent() {

		FileWriter fileWriter = new FileWriter(new File(resourceFile
				.getParent(), resourceFile.getName() + "_tmp"), Charsets
				.getCharsetInstance(CharsetType.UTF_8));

		FileReader fileReader = new FileReader(resourceFile, Charsets
				.getCharsetInstance(CharsetType.UTF_8));

		fileReader.setNoTrimLine();

		while (fileReader.hasNext()) {

			fileWriter.writeln(StringUtils.replace(fileReader.readLine(),
					this.fromName, this.toName));
		}

		fileReader.close();

		fileWriter.close();

		return fileWriter.getFile();
	}



}
