package com.rapid.j2ee.framework.build;

import java.io.File;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class BuildResourceName {

	private File resourceFile;

	private String fromName;

	private String toName;

	public BuildResourceName(File resourceFile, String fromName, String toName) {
		this.resourceFile = resourceFile;
		this.fromName = fromName;
		this.toName = toName;
	}

	public File rename() {

		String fileName = StringUtils.replace(resourceFile.getName(), fromName,
				toName);

		File targetFile = new File(resourceFile.getParent(), fileName);

		resourceFile.renameTo(targetFile);

		return targetFile;
	}

	public static void main(String[] args) {

		File target = new File(
				"src/main/resources/spring/spring_frameworkdemo_appconfig_c3p0.xml");

		System.out.println(target.getAbsolutePath());

		//target = new BuildResourceName(target, "chinaetax", "frameworkdemo")
				//.rename();

		new BuildResourceContentResolve(target, "chinaetax", "frameworkdemo")
				.resolve();
	}

}
