package com.rapid.j2ee.framework.core.annoconverter;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.annoconverter.converter.AnnotationTypeConverter;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;

@Component
public class AnnotationTypeConverterFactory implements InitializingBean {

	public Object convert(Annotation annotation, Object obj) {

		if (!annotationTypeConverterMap.containsKey(annotation.annotationType()
				.toString())) {

			Logger.warn("Please provide a annotation type converter ! "
					+ annotation);

			return obj;
		}

		return annotationTypeConverterMap.get(
				annotation.annotationType().toString())
				.convert(annotation, obj);

	}

	public void afterPropertiesSet() throws Exception {
		annotationTypeConverterMap = CollectionsUtil
				.convertCollectionToMapByFieldNames(annotationTypeConverters,
						"annotationType");
	}

	@Autowired(required = false)
	private List<AnnotationTypeConverter> annotationTypeConverters = new ArrayList<AnnotationTypeConverter>();

	private Map<String, AnnotationTypeConverter> annotationTypeConverterMap = null;

	private static Log Logger = LogFactory
			.getLog(AnnotationTypeConverterFactory.class);

}
