package com.rapid.j2ee.framework.core.annoconverter.converter;

import java.lang.annotation.Annotation;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.utils.StringUtils;

@Component
public class NullToEmptyTypeConverter implements AnnotationTypeConverter {

	public Object convert(Annotation annotation, Object obj) {

		NullToEmpty nullToEmpty = (NullToEmpty) annotation;

		return StringUtils.trimToEmpty((String) obj, nullToEmpty.value());

	}

	public Class getAnnotationType() {

		return NullToEmpty.class;
	}

}
