package com.rapid.j2ee.framework.core.annoconverter.converter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.annoconverter.converter.SqlLikeType.LikeType;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.utils.SqlParserUtils;

@Component
public class SqlLikeTypeTyperConverter implements AnnotationTypeConverter {

	public Object convert(Annotation annotation, Object obj) {

		SqlLikeType sqlLikeType = (SqlLikeType) annotation;

		if (TypeChecker.isNull(obj)) {
			if (sqlLikeType.supportsNull()) {
				return null;
			}
		}

		if (obj instanceof Object[]) {

			for (int i = 0, j = Array.getLength(obj); i < j; i++) {
				Array.set(obj, i, SqlParserUtils.toLikeSqlValue(Array.get(obj,
						i), sqlLikeType.value()));
			}

			return obj;
		}

		return SqlParserUtils.toLikeSqlValue(obj, sqlLikeType.value());
	}

	public Class getAnnotationType() {

		return SqlLikeType.class;
	}

	public static void main(String[] args) {
		Object arrays = new String[] { "1", "2" };

		System.out.println((arrays instanceof Object[]));
	}

}
