package com.rapid.j2ee.framework.core.annoconverter.converter;

import java.lang.annotation.Annotation;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;

@Component
public class StringToDateTyperConverter implements AnnotationTypeConverter {

	public Object convert(Annotation annotation, Object obj) {

		if (TypeChecker.isNull(obj)) {
			return null;
		}

		StringToDate stringToDate = (StringToDate) annotation;

		return DateTimeUtils.convertWebToDate((String) obj, DateTimeFormat
				.getDateTimeFormat(stringToDate.value()));
	}

	public Class getAnnotationType() {

		return StringToDate.class;
	}

}
