package com.rapid.j2ee.framework.core.collections;

import java.util.ArrayList;
import java.util.Collection;

public class ArrayFixedList<E> extends ArrayList<E> {

	private int maxSize = 0;

	private int reductionSize = 1;

	public ArrayFixedList(int maxSize, int reductionSize) {
		super(maxSize);
		this.maxSize = maxSize;
		this.reductionSize = reductionSize;
	}

	@Override
	public void add(int index, E element) {
		resizeOverCapacity();
		super.add(index, element);
	}

	@Override
	public boolean add(E e) {
		resizeOverCapacity();
		return super.add(e);
	}

	@Override
	public E set(int index, E element) {
		resizeOverCapacity();
		return super.set(index, element);
	}

	@Override
	public boolean addAll(Collection<? extends E> c) {

		boolean flag = false;

		for (E element : c) {
			flag = add(element);
		}

		return flag;

	}

	@Override
	public boolean addAll(int index, Collection<? extends E> c) {

		for (E element : c) {
			add(index, element);
		}

		return true;
	}

	private void resizeOverCapacity() {

		if (this.size() < maxSize) {
			return;
		}

		for (int i = 0; i < reductionSize; i++) {
			this.remove(0);
		}
	}
	
	public static void main(String[] args) {
		ArrayFixedList<Integer> list = new ArrayFixedList<Integer>(10,1);
		
		for(int i=0;i<12;i++){
			list.add(i);
		}
		System.out.println(list);
	}
	
}
