package com.rapid.j2ee.framework.core.collections;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("hiding")
public class HashMapAsKeyIgnoreCase<T> extends HashMap<String, T> {

	public HashMapAsKeyIgnoreCase() {
		super();
	}

	public HashMapAsKeyIgnoreCase(Map<String, T> maps) {

		for (String key : maps.keySet()) {
			this.put(key, maps.get(key));
		}

	}

	public HashMapAsKeyIgnoreCase(int initialCapacity, float loadFactor) {
		super(initialCapacity, loadFactor);
	}

	public HashMapAsKeyIgnoreCase(int initialCapacity) {
		super(initialCapacity);
	}

	public T put(String key, T value) {

		return super.put(key.toUpperCase(), value);
	}

	@Override
	public boolean containsKey(Object key) {
		return super.containsKey(String.valueOf(key).toUpperCase());
	}

	@Override
	public T get(Object key) {

		return super.get(String.valueOf(key).toUpperCase());
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

}
