package com.rapid.j2ee.framework.core.collections;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;

import java.util.HashMap;

import java.util.Iterator;

import java.util.List;

import java.util.Map;

import java.util.Set;

public class MultiHashMap<K extends Object, V extends List> extends AbstractMap {

	public MultiHashMap() {

		contains = new HashMap<K, V>();

	}

	@Override
	public Set entrySet() {

		return contains.entrySet();

	}

	@Override
	public Object put(Object k, Object v) {

		if (v == null) {
			return null;
		}

		if (!contains.containsKey(k)) {
			contains.put(k, new ArrayList());
		}

		boolean isCollection = v instanceof Collection;

		if (isCollection) {

			((List) contains.get(k)).addAll((List) v);

		} else {
			((List) contains.get(k)).add(v);
		}

		return v;

	}

	public Object putCollection(K k, V v) {

		return put(k, v);

	}

	public V getCollection(K k) {
		return (V) contains.get(k);
	}

	private Map contains;

}