package com.rapid.j2ee.framework.core.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SortHashMap implements Map, Serializable {
	private List keyList;

	private List objectList;

	public SortHashMap(int keySize, int objSize) {
		keyList = new ArrayList(keySize);
		objectList = new ArrayList(objSize);
	}

	public SortHashMap(int size) {
		keyList = new ArrayList(size);
		objectList = new ArrayList();
	}

	public SortHashMap() {
		keyList = new ArrayList();
		objectList = new ArrayList();
	}

	// Methods
	public int size() {
		return this.keyList.size();
	}

	public boolean isEmpty() {
		return this.keyList.isEmpty();
	}

	public boolean containsKey(Object object) {
		return this.keyList.contains(object);
	}

	public boolean containsValue(Object object) {
		return this.objectList.contains(object);
	}

	public Object get(Object object) {
		int index = this.keyList.indexOf(object);
		if (index >= 0 && index < this.size()) {
			return this.objectList.get(index);
		}
		return null;
	}

	public Object put(Object object, Object object1) {
		if (this.containsKey(object)) {
			remove(object);
		}
		this.keyList.add(object);
		this.objectList.add(object1);
		return object1;
	}

	public Object remove(Object object) {
		int index = this.keyList.indexOf(object);
		this.keyList.remove(object);
		return this.objectList.remove(index);
	}

	public void putAll(SortHashMap map) {
		for (Iterator it = map.keyList().iterator(); it.hasNext();) {
			Object obj = it.next();
			this.put(obj, map.get(obj));
		}

	}

	public void putAll(Map map) {
		throw new UnsupportedOperationException("putAll(Map map)");
	}

	public void clear() {
		this.keyList.clear();
		this.objectList.clear();
	}

	public Set keySet() {
		return new HashSet(this.keyList);
	}

	public List keyList() {
		return this.keyList;
	}

	public Collection values() {
		return this.objectList;
	}

	public Set entrySet() {
		throw new UnsupportedOperationException("entrySet()");
	}

	public boolean equals(Object object) {
		SortHashMap seqMap = (SortHashMap) object;
		return this.keyList.equals(seqMap.keyList)
				&& this.objectList.equals(seqMap.objectList);
	}

	public int hashCode() {
		return this.keyList.hashCode() + this.objectList.hashCode();
	}

	public String toString() {

		StringBuffer sb = new StringBuffer();

		int j = Math.min(this.keyList.size(), this.objectList.size());

		for (int i = 0; i < j; i++) {

			sb.append(keyList.get(i));
			sb.append("=");
			sb.append(objectList.get(i));
			sb.append("  ");
		}

		return sb.toString();
	}

}