package com.rapid.j2ee.framework.core.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.MultiMap;

@SuppressWarnings("serial")
public class SortMultiHashMap extends SortHashMap implements MultiMap,
		SortMultiMap {

	private static int sCount = 0;

	private String mName;

	private boolean linkListMode;

	public void setLinkListMode(boolean linkListMode) {
		this.linkListMode = linkListMode;
	}

	public SortMultiHashMap() {
		mName = null;
		setName();
	}

	public SortMultiHashMap(int i) {
		super(i);
		mName = null;
		setName();
	}

	public void clear() {
		Set set = super.entrySet();
		List arraylist;
		for (Iterator iterator = set.iterator(); iterator.hasNext(); arraylist
				.clear()) {
			java.util.Map.Entry entry = (java.util.Map.Entry) iterator.next();
			arraylist = (List) entry.getValue();
		}

		super.clear();
	}

	public Object clone() {
		try {
			SortMultiHashMap multihashmap = (SortMultiHashMap) super.clone();
			multihashmap.mName = mName;
			return multihashmap;
		} catch (Exception e) {
			return null;
		}
	}

	public boolean containsValue(Object obj) {
		Set set = super.entrySet();
		if (set == null)
			return false;
		for (Iterator iterator = set.iterator(); iterator.hasNext();) {
			java.util.Map.Entry entry = (java.util.Map.Entry) iterator.next();
			List arraylist = (List) entry.getValue();
			if (arraylist.contains(obj))
				return true;
		}

		return false;
	}

	public String getName() {
		return mName;
	}

	public Object put(Object obj, Object obj1) {

		List arraylist = (List) super.get(obj);
		if (arraylist == null) {
			arraylist = newListInstance(10);
			super.put(obj, arraylist);
		}
		boolean flag = false;
		if (obj1 instanceof Collection) {
			flag = arraylist.addAll((Collection) obj1);
		} else {
			flag = arraylist.add(obj1);
		}

		return flag ? obj1 : null;
	}
	
	private List newListInstance(int size){
		return this.linkListMode? new LinkedList() : new ArrayList(size);
	}

	public void putAll(Map map) {
		super.putAll(map);
	}

	public Object remove(Object obj, Object obj1) {
		List arraylist = (List) super.get(obj);
		if (arraylist == null) {
			return null;
		} else {
			arraylist.remove(obj1);
			return obj1;
		}
	}

	private void setName() {
		sCount++;
		mName = "MultiMap-" + sCount;
	}

	public Collection values() {
		List arraylist = newListInstance(super.size());
		Set set = super.entrySet();
		for (Iterator iterator = set.iterator(); iterator.hasNext();) {
			java.util.Map.Entry entry = (java.util.Map.Entry) iterator.next();
			List arraylist1 = (List) entry.getValue();
			Object aobj[] = arraylist1.toArray();
			for (int i = 0; i < aobj.length; i++)
				arraylist.add(aobj[i]);

		}

		return arraylist;
	}

	public List getList(Object obj) {
		return (List) super.get(obj);
	}

	public String toString() {
		List keys = this.keyList();
		StringBuffer sb = new StringBuffer(100);
		for (int i = 0; i < keys.size(); i++) {
			sb.append(keys.get(i) + " = " + this.get(keys.get(i)));
			sb.append("\r\n");
		}
		return sb.toString();
	}

}