package com.rapid.j2ee.framework.core.cryptology;

import java.util.Map;
import java.util.Set;

import com.rapid.j2ee.framework.core.collections.SynchronizedHashMap;
import com.rapid.j2ee.framework.core.cryptology.revsersible.CryptologyReversible;
import com.rapid.j2ee.framework.core.cryptology.single.SingleCryptology;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.ResolverUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class CryptologyFactory {

	public static CryptologyReversible getReversibleCryptology(
			CryptologyType type) {
		return getReversibleCryptology(type, null);
	}

	public static CryptologyReversible getReversibleCryptology(
			CryptologyType type, Object cryptologyParameter) {
		return (CryptologyReversible) getCryptologyInstance(type,
				cryptologyParameter);
	}

	public static SingleCryptology getSingleCryptology(CryptologyType type) {
		return getSingleCryptology(type, null);
	}

	public static SingleCryptology getSingleCryptology(CryptologyType type,
			Object cryptologyParameter) {
		return (SingleCryptology) getCryptologyInstance(type,
				cryptologyParameter);
	}

	public synchronized static CryptologyConfigure getCryptologyInstance(
			CryptologyType type, Object cryptologyParameter) {

		doInitialCryptologyProviders();

		CryptologyDefinition cryptologyDefinition = CryptologyDefinition_Container
				.get(type);

		if (!cryptologyDefinition.isSingleton()) {
			return getCryptologyInstanceSub(cryptologyDefinition,
					cryptologyParameter);
		}

		clearSmart();

		String typeKey = getCryptologyConfigureKey(type, cryptologyParameter);

		if (!CryptologyInstance_Container.containsKey(typeKey)) {

			CryptologyInstance_Container.put(typeKey, getCryptologyInstanceSub(
					cryptologyDefinition, cryptologyParameter));
		}

		return CryptologyInstance_Container.get(typeKey);
	}

	private static void clearSmart() {
		if (CryptologyDefinition_Container.size() >= Cryptology_Cache_Max_Size) {
			clear();
		}
	}

	private static String getCryptologyConfigureKey(CryptologyType type,
			Object cryptologyParameter) {
		return type + "." + ObjectAnalyzer.toString(cryptologyParameter);
	}

	private static CryptologyConfigure getCryptologyInstanceSub(
			CryptologyDefinition cryptologyDefinition, Object params) {

		CryptologyConfigure cryptologyConfigure = (CryptologyConfigure) ConstructorUtils
				.newInstance(cryptologyDefinition.getCryptologyClass());

		cryptologyConfigure.initial(params);

		return cryptologyConfigure;
	}

	public static void clear() {
		CryptologyInstance_Container.clear();
	}

	private static void doInitialCryptologyProviders() {

		if (!TypeChecker.isEmpty(CryptologyDefinition_Container)) {
			return;
		}

		Set<Class> sets = ResolverUtils.findImplementations(
				CryptologyConfigure.class, CryptologyConfigure.class
						.getPackage().getName());

		for (Class clz : sets) {

			CryptologyConfigure prepare = (CryptologyConfigure) ConstructorUtils
					.newInstance(clz);

			CryptologyDefinition_Container.put(prepare.getCryptologyType(),
					new CryptologyDefinition(prepare.isSingleton(), prepare
							.getClass()));

		}

	}

	private CryptologyFactory() {

	}

	private static final Map<CryptologyType, CryptologyDefinition> CryptologyDefinition_Container = new SynchronizedHashMap<CryptologyType, CryptologyDefinition>();

	private static final Map<String, CryptologyConfigure> CryptologyInstance_Container = new SynchronizedHashMap<String, CryptologyConfigure>(
			5);

	private static final int Cryptology_Cache_Max_Size = 250;

	public static void main(String[] args) {

		// Base64CryptologyReversible

		System.out.println(CryptologyFactory.getSingleCryptology(
				CryptologyType.CRC32).encrypt("123"));
		System.out.println(CryptologyFactory.getReversibleCryptology(
				CryptologyType.Base64).decrypt("6YOd5rW36Juf"));

	}
}
