package com.rapid.j2ee.framework.core.cryptology;

import com.rapid.j2ee.framework.core.io.file.ResourceLocationType;

public enum CryptologyType {

	Md5("MD5"), SHA1("SHA1"), AES_File("AES", ResourceLocationType.File), AES_Class(
			"AES", ResourceLocationType.ClassPath), AES128_Command("AES", 128), AES256_Command(
			"AES", 256), Base64("BASE64"), ELM("ELM"), CRC32("CRC32");

	private String method;

	private Object parameter;

	private CryptologyType(String method, Object parameter) {
		this.method = method;
		this.parameter = parameter;
	}

	private CryptologyType(String method) {
		this.method = method;
	}

	public String getMethod() {
		return method;
	}

	public String toString() {
		return this.method;
	}

	public Object getParameter() {
		return parameter;
	}

}
