package com.rapid.j2ee.framework.core.cryptology.placeholder;

import com.rapid.j2ee.framework.core.cryptology.CryptologyFactory;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;

public class AESCommandDecryptPropertyPlaceholderConfigurer extends
		DecryptPropertyPlaceholderConfigurer {

	public AESCommandDecryptPropertyPlaceholderConfigurer() {

	}

	public AESCommandDecryptPropertyPlaceholderConfigurer(String command) {
		this.command = CryptologyFactory
				.getSingleCryptology(CryptologyType.Md5).encrypt(
						command + this.getClass());
	}

	@Override
	protected String decrypt(String key, String value) {

		return CryptologyFactory.getReversibleCryptology(
				CryptologyType.AES128_Command, command).decrypt(value);
	}

	public void setCommand(String command) {
		this.command = CryptologyFactory
				.getSingleCryptology(CryptologyType.Md5).encrypt(
						command + this.getClass());
	}

	@Override
	protected String encryptForDebug(String key, String value) {

		return CryptologyFactory.getReversibleCryptology(
				CryptologyType.AES128_Command, command).encrypt(value);
	}

	private String command;

}
