package com.rapid.j2ee.framework.core.cryptology.placeholder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class DecryptPropertyPlaceholderConfigurer extends
		PropertyPlaceholderConfigurer {

	private String debug;

	public DecryptPropertyPlaceholderConfigurer() {

	}

	public void setDebug(String debug) {

		this.debug = debug;
	}

	protected final boolean isDebugMode() {

		return TypeChecker.isSpecialTrue(this.debug);
	}

	@Override
	protected String convertProperty(String key, String value) {

		String decryptValue = decrypt(key, value);

		if (!StringUtils.equals(decryptValue, value)) {

			if (this.isDebugMode()) {
				
				logger.info("Convert Property Key[" + key + "] Value[" + value
						+ "] Encrypted Value["
						+ this.encryptForDebug(key, value) + "]");
			}
		}

		return TypeChecker.isEmpty(decryptValue) ? value : decryptValue;
	}

	protected abstract String decrypt(String key, String value);

	protected abstract String encryptForDebug(String key, String value);

	private Log logger = LogFactory.getLog(this.getClass());

}
