package com.rapid.j2ee.framework.core.cryptology.revsersible;

import java.security.SecureRandom;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public abstract class AESCommandCryptologyReversible extends
		AESCryptologyReversible {

	@Override
	protected SecretKey getSecretKey(KeyGenerator kgen, Object params)
			throws Exception {

		SecureRandom securerandom = SecureRandom.getInstance("SHA1PRNG");

		securerandom.setSeed(String.valueOf(params).getBytes());

		kgen.init(((Integer) getCryptologyType().getParameter()).intValue(),
				securerandom);

		return kgen.generateKey();

	}



}
