package com.rapid.j2ee.framework.core.cryptology.revsersible;

import java.security.Provider;
import java.security.Security;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;


import sun.misc.BASE64Decoder;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class AbstractCipherCryptologyReversible extends
		AbstractCryptologyReversible implements CipherCryptologyReversible {

	// A Encrypt Cipher
	protected Cipher encryptCipher;

	// A Decrypt Cipher
	protected Cipher decryptCipher;

	public static final String CRYPTO_ERROR = "AbstractCipherCryptologyReversible_Error";

	@Override
	protected byte[] doDecrypt(byte[] value) throws Exception {

		return decryptCipher.doFinal(value);
	}

	protected byte[] decryptFilter(String value, Charset charset)
			throws Exception {

		return new BASE64Decoder().decodeBuffer(value);
	}

	@Override
	protected byte[] doEncrypt(byte[] value) throws Exception {
		return this.encryptCipher.doFinal(value);
	}

	protected String encryptFilter(byte[] bs, Charset charset) throws Exception {
		return new sun.misc.BASE64Encoder().encode(bs);

	}

	public void initial(Object params) {

		registerProvider(this.getProvider());

		printProviders();

		try {
			SecretKeySpec skeySpec = new SecretKeySpec(
					this
							.getSecretKey(
									KeyGenerator.getInstance(this
											.getCryptoAlgorithm()), params)
							.getEncoded(), this.getCryptoAlgorithm());

			// Get instances of the ciphers
			encryptCipher = Cipher.getInstance(this.getTransformation());
			decryptCipher = Cipher.getInstance(this.getTransformation());

			encryptCipher.init(Cipher.ENCRYPT_MODE, skeySpec);
			decryptCipher.init(Cipher.DECRYPT_MODE, skeySpec);

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	// Show security infor
	protected void printProviders() {
		Provider[] ps = Security.getProviders();
//		System.out.println();
//		for (int i = 0; i < ps.length; i++) {
//			System.out
//					.println("Security Provider Name:" + ps[i].getName()
//							+ " Class:" + ps[i].getClass() + " Info:"
//							+ ps[i].getInfo());
//
//		}
//
//		System.out.println();

	}

	/**
	 * Register a provider into JVM
	 * 
	 * 
	 * @param provider --
	 *            a provider you require
	 */
	protected void registerProvider(Provider provider) {

		if (TypeChecker.isNull(provider)) {
			return;
		}
		Provider[] ps = Security.getProviders();
		for (int i = 0; i < ps.length; i++) {
			if (ps[i].getName().equals(provider.getName())) {
				return;
			}
		}

		Security.addProvider(provider);

	}

	public Cipher getEncryptCipher() {
		return this.encryptCipher;
	}

	public Cipher getDecryptCipher() {
		return this.decryptCipher;
	}

	// All sub class must implement this method.
	// This is a hook.
	protected abstract Provider getProvider();

	/**
	 * A abstract method to define a method name for providing a security key
	 * array.
	 * 
	 * @return -- a array of security key
	 * @throws ServiceException
	 */
	protected abstract SecretKey getSecretKey(KeyGenerator kgen, Object params)
			throws Exception;

	/**
	 * Crypto-Alogrithm Name such as AES, DES....
	 * 
	 * @return Crypto-Alogrithm Name
	 */
	protected abstract String getCryptoAlgorithm();

	/**
	 * Crypto-Transformation Name Such as AES, DES/ECB/PKCS5Padding
	 */
	protected abstract String getTransformation();

}
