package com.rapid.j2ee.framework.core.cryptology.revsersible;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.cryptology.CryptologyConfigure;
import com.rapid.j2ee.framework.core.utils.HexUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class AbstractCryptologyReversible implements
		CryptologyReversible, CryptologyConfigure {

	protected abstract byte[] doEncrypt(byte value[]) throws Exception;

	protected abstract byte[] doDecrypt(byte value[]) throws Exception;

	public String encrypt(String value) {

		return encrypt(value, Charsets.getCharsetInstance(CharsetType.UTF_8));
	}

	public String decrypt(String value) {
		return decrypt(value, Charsets.getCharsetInstance(CharsetType.UTF_8));
	}

	public String decrypt(String value, Charset charset) {

		if (TypeChecker.isEmpty(value)) {
			return "";
		}

		try {
			return new String(doDecrypt(decryptFilter(value, charset)), charset
					.getCharset());
		} catch (Exception e) {
			return "";
		}
	}

	protected byte[] decryptFilter(String value, Charset charset)
			throws Exception {
		return value.getBytes(Charsets.getCharsetInstance(CharsetType.ENGLISH)
				.getCharset());
	}

	public String encrypt(String value, Charset charset) {

		value = StringUtils.trimToEmpty(value);

		try {
			return encryptFilter(
					doEncrypt(value.getBytes(charset.getCharset())), charset);

		} catch (Exception e) {
			return "";
		}
	}

	protected String encryptFilter(byte[] bs, Charset charset) throws Exception {
		return new String(bs, Charsets.getCharsetInstance(CharsetType.ENGLISH)
				.getCharset());
	}

	// 将字节数组转换为十六进制字符串
	public String toHex(byte blocks[]) {

		return HexUtils.toHex(blocks);
	}

}
