package com.rapid.j2ee.framework.core.cryptology.revsersible;

import com.rapid.j2ee.framework.core.cryptology.CryptologyType;

public class Base64 extends AbstractCryptologyReversible {

	@Override
	protected byte[] doDecrypt(byte[] value) {

		return org.apache.commons.codec.binary.Base64.decodeBase64(value);
	}

	@Override
	protected byte[] doEncrypt(byte[] value) {

		return org.apache.commons.codec.binary.Base64.encodeBase64(value);
	}

	public CryptologyType getCryptologyType() {

		return CryptologyType.Base64;
	}

	public boolean isSingleton() {

		return true;
	}

	public void initial(Object params) {

	}

	public static void main(String[] args) {

		Base64 base64 = new Base64();

		System.out.println(base64.encrypt("郝海蛟"));
	}

}
