package com.rapid.j2ee.framework.core.cryptology.revsersible;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.cryptology.CryptologyConfigure;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.PropertiesUtils;
import com.rapid.j2ee.framework.core.utils.RandomUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class EnglishLetterMapCryptologyReversible implements
		CryptologyReversible, CryptologyConfigure {

	public String decrypt(String value, Charset charset) {

		return decrypt(value);
	}

	public String decrypt(String value) {

		for (int i = englishLetterMapDecryptProperties.size() - 1; i >= 0; i--) {
			value = doDecrypt(value, englishLetterMapDecryptProperties.get(i));
		}
		return value;
	}

	private String doDecrypt(String value,
			Properties englishLetterMapDecryptProperties) {

		if (TypeChecker.isEmpty(value)) {
			return value;
		}

		StringBuilder decodedCode = new StringBuilder(value.length());

		for (char c : value.toCharArray()) {

			if (englishLetterMapDecryptProperties
					.containsKey(String.valueOf(c))) {

				decodedCode.append(englishLetterMapDecryptProperties.get(String
						.valueOf(c)));

				continue;
			}

			decodedCode.append(String.valueOf(c));
		}

		return decodedCode.toString();
	}

	public String encrypt(String value, Charset charset) {

		return encrypt(value);
	}

	public String encrypt(String value) {

		for (int i = 0; i < englishLetterMapEncryptProperties.size(); i++) {
			value = doEncrypt(value, englishLetterMapEncryptProperties.get(i));
		}
		return value;
	}

	private String doEncrypt(String value,
			Properties englishLetterMapEncryptProperties) {

		if (TypeChecker.isEmpty(value)) {
			return value;
		}

		StringBuilder encodedCode = new StringBuilder(value.length());

		for (char c : value.toCharArray()) {

			String enc = (String) englishLetterMapEncryptProperties.get(String
					.valueOf(c));

			encodedCode.append(enc == null ? c : enc);
		}

		return encodedCode.toString();
	}

	public CryptologyType getCryptologyType() {

		return CryptologyType.ELM;
	}

	public void initial(Object params) {

		addEnglishLetterMapSecretProperties(Default_EnglishLetterMap_Properties_File);

		addEnglishLetterMapSecretProperties((String) params);

		addEnglishLetterMapSecretProperties(Default_EnglishLetterMap_Properties_File1);

		addEnglishLetterMapSecretProperties((String) params);

		addEnglishLetterMapSecretProperties(Default_EnglishLetterMap_Properties_File2);
	}

	private void addEnglishLetterMapSecretProperties(String secretMapPath) {

		if (TypeChecker.isEmpty(secretMapPath)) {
			return;
		}

		Properties props = PropertiesUtils.getProperties(secretMapPath, false);

		System.out.println("secretMapPath ==================" + secretMapPath);
		System.out.println("Props ===== " + props);

		englishLetterMapEncryptProperties.add(props);

		englishLetterMapDecryptProperties.add(PropertiesUtils.revise(props));
	}

	public boolean isSingleton() {

		return true;
	}

	public String toHex(byte[] blocks) {

		throw new UnsupportedOperationException("toHex(byte[] blocks)");
	}

	public static void storeNewSecretMapProperties(String secretEnglishLetters,
			String fileName) {

		if (TypeChecker.isEmpty(secretEnglishLetters)) {
			secretEnglishLetters = Default_Secret_EnglishLetters;
		}

		Properties secretMap = new Properties();

		for (char c : secretEnglishLetters.toCharArray()) {

			if (secretEnglishLetters.length() == 1) {
				secretMap.setProperty(String.valueOf(c), secretEnglishLetters);
				break;
			}

			String mapCharLetter = RandomUtils.nextRandomText(StringUtils
					.remove(secretEnglishLetters, String.valueOf(c)), 1);

			secretMap.setProperty(String.valueOf(c), mapCharLetter);

			secretEnglishLetters = StringUtils.remove(secretEnglishLetters,
					mapCharLetter);

		}

		FileOutputStream os = null;

		try {

			os = new FileOutputStream(fileName);

			FileUtils.makeDir(fileName);

			secretMap.store(os, "English Letter Secret Map!");

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);

		} finally {
			FileUtils.close(os);
		}

	}

	public static void main(String[] args) {

		EnglishLetterMapCryptologyReversible eng = new EnglishLetterMapCryptologyReversible();
		eng.initial(null);

		System.out.println(eng.encrypt("test"));

		System.out.println(eng.doDecrypt("0kf0",
				eng.englishLetterMapDecryptProperties.get(2)));

		EnglishLetterMapCryptologyReversible.storeNewSecretMapProperties(
				Default_Secret_EnglishLetters, "test.properties");

	}

	public static final String Default_Secret_EnglishLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";

	private static final String Default_EnglishLetterMap_Properties_File = "SecretEnglishLetters.properties";

	private static final String Default_EnglishLetterMap_Properties_File1 = "SecretEnglishLetters1.properties";

	private static final String Default_EnglishLetterMap_Properties_File2 = "SecretEnglishLetters2.properties";

	private List<Properties> englishLetterMapEncryptProperties = new ArrayList<Properties>(
			5);

	private List<Properties> englishLetterMapDecryptProperties = new ArrayList<Properties>(
			5);

}
