package com.rapid.j2ee.framework.core.cryptology.single;

import java.io.UnsupportedEncodingException;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.cryptology.CryptologyConfigure;
import com.rapid.j2ee.framework.core.utils.HexUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public abstract class AbstractSingleCryptology implements SingleCryptology,
		CryptologyConfigure {

	public final String encrypt(String value, Charset charset) {
		try {
			return doEncrypt(StringUtils.trimToEmpty(value).getBytes(
					charset.getCharset()), charset);
		} catch (UnsupportedEncodingException e) {
			return doEncrypt(StringUtils.trimToEmpty(value).getBytes(), charset);
		}
	}

	public final String encrypt(String value) {

		return encrypt(value, Charsets.getCharsetInstance(CharsetType.GLOBAL));
	}

	protected abstract String doEncrypt(byte value[], Charset charset);

	public String toHex(byte[] blocks) {
		return HexUtils.toHex(blocks);
	}

}
