package com.rapid.j2ee.framework.core.cryptology.single;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.file.FileReader;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class CRC32 extends AbstractSingleCryptology {

	@Override
	protected String doEncrypt(byte[] value, Charset charset) {

		try {
			return (String) crc32Invocable.invokeFunction("CRC32", new String(
					value, charset.getCharset()));
		} catch (Exception e) {
			return "";
		}
	}

	public CryptologyType getCryptologyType() {

		return CryptologyType.CRC32;
	}

	public void initial(Object params) {

		try {

			ScriptEngineManager manager = new ScriptEngineManager();

			ScriptEngine engine = manager.getEngineByName("javascript");

			Reader fr = new InputStreamReader(CRC32.class
					.getResourceAsStream("CRC32.js"));

			engine.eval(fr);

			crc32Invocable = (Invocable) engine;

		} catch (ScriptException e) {

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	public boolean isSingleton() {

		return true;
	}

	private Invocable crc32Invocable = null;

}
