package com.rapid.j2ee.framework.core.cryptology.single;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;

public class Md5 extends AbstractSingleCryptology {

	private MessageDigest messageDigest = null;

	@Override
	protected String doEncrypt(byte[] values, Charset charset) {

		messageDigest.update(values);

		return toHex(messageDigest.digest());

	}

	public boolean isSingleton() {

		return false;
	}

	public void initial(Object params) {

		try {
			messageDigest = MessageDigest.getInstance(this.getCryptologyType()
					.getMethod());
		} catch (NoSuchAlgorithmException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	public CryptologyType getCryptologyType() {

		return CryptologyType.Md5;
	}

	public static void main(String[] args) {

		Md5 crypt = new Md5();

		crypt.initial(null);

		System.out.println(crypt.encrypt("Abcc123"));

	}

}
