package com.rapid.j2ee.framework.core.exception;

import com.rapid.j2ee.framework.mvc.constants.OperationResult;
import com.rapid.j2ee.framework.mvc.constants.SupportActionConstants;

public class ApplicationException extends BaseException {

	private static final long serialVersionUID = 1L;

	private String resultMessageCode;

	private Object[] resultMessageArguments;

	private String pageIndicator = SupportActionConstants.SupportAction_Page_Indicator_By_CommonApplicationException;

	private Object outputResult;
	

	public ApplicationException(OperationResult operationResult,
			Throwable cause, String pageIndicator) {
		this(operationResult.getResultCode(), operationResult.getMessageCode(),
				operationResult.getMessageDefault(), null, cause);
		this.pageIndicator = pageIndicator;
	}

	public ApplicationException(OperationResult operationResult, String error,
			String pageIndicator) {
		this(operationResult.getResultCode(), operationResult.getMessageCode(),
				operationResult.getMessageDefault(), null);
		this.pageIndicator = pageIndicator;
	}

	public ApplicationException(OperationResult operationResult,
			String pageIndicator) {

		this(operationResult);

		this.pageIndicator = pageIndicator;
	}

	public ApplicationException(OperationResult operationResult) {
		this(operationResult.getResultCode(), operationResult.getMessageCode(),
				operationResult.getMessageDefault(), null);
	}

	public ApplicationException(int resultCode, String resultMessageCode,
			String resultMessage, Object[] resultMessageArguments,
			Throwable error) {
		super(resultCode, resultMessage, error);
		this.resultMessageCode = resultMessageCode;
		this.resultMessageArguments = resultMessageArguments;
	}

	public ApplicationException(int resultCode, String resultMessageCode,
			String resultMessage, Throwable error) {
		super(resultCode, resultMessage, error);
		this.resultMessageCode = resultMessageCode;
	}

	public ApplicationException(int resultCode, String resultMessageCode,
			String resultMessage) {
		super(resultCode, resultMessage, null);
		this.resultMessageCode = resultMessageCode;
	}

	public Object[] getResultMessageArguments() {
		return resultMessageArguments;
	}

	public String getResultMessageCode() {
		return resultMessageCode;
	}

	public ApplicationException setResultMessageCode(String resultMessageCode) {
		this.resultMessageCode = resultMessageCode;
		return this;
	}

	public String getPageIndicator() {
		return pageIndicator;
	}

	public ApplicationException setPageIndicator(String pageIndicator) {
		this.pageIndicator = pageIndicator;
		return this;
	}

	public ApplicationException setResultMessageArguments(
			Object... resultMessageArguments) {
		this.resultMessageArguments = resultMessageArguments;
		return this;
	}

	public boolean isSuccess() {
		return this.resultCode == OperationResult.Success;
	}

	public ApplicationException setOutputResult(Object outputResult) {
		this.outputResult = outputResult;

		return this;
	}

	public Object getOutputResult() {
		return outputResult;
	}

}
