package com.rapid.j2ee.framework.core.exception;

import com.rapid.j2ee.framework.mvc.constants.OperationResult;

@SuppressWarnings("serial")
public abstract class BaseException extends RuntimeException {

	public static final int Unkown_Error_Code = OperationResult.System_Error;

	public static final String Unkown_Error_Message = "Unkown Exception";

	protected int resultCode = Unkown_Error_Code;

	protected String resultMessage = Unkown_Error_Message;

	public BaseException(int resultCode, String resultMessage, Throwable cause) {
		super(resultMessage, cause);
		this.resultCode = resultCode;
		this.resultMessage = resultMessage;

	}

	public BaseException(int resultCode, String resultMessage) {
		super(resultMessage);
		this.resultCode = resultCode;
		this.resultMessage = resultMessage;

	}

	public String getResultMessage() {
		return resultMessage;
	}

	public int getResultCode() {
		return resultCode;
	}

}
