package com.rapid.j2ee.framework.core.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.rapid.j2ee.framework.core.exception.support.ExceptionTranslator;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public final class ExceptionUtils {

	public static String printThrowableStack(Throwable ep) {

		if (TypeChecker.isNull(ep)) {
			return "";

		}
		StringWriter sw = new StringWriter(2000);
		PrintWriter writer = new PrintWriter(sw);
		ep.printStackTrace(writer);
		writer.flush();
		writer.close();

		return sw.toString();

	}

	public static BaseException convertThrowableToBaseException(Throwable ep) {

		int count = -1;

		while (count++ < TRY_INVOCATIONTARGET_COUNTS
				&& ep instanceof InvocationTargetException) {
			ep = ((InvocationTargetException) ep).getTargetException();

		}

		if (ep instanceof BaseException) {
			return (BaseException) ep;
		}

		return translateException(ep);
	}

	private static BaseException translateException(Throwable ep) {

		if (!SpringApplicationContextHolder.isApplicationContextHolden()) {
			return new SystemException(ep);
		}

		injectExceptionTranslators();

		for (ExceptionTranslator exceptionTranslator : exceptionTranslators) {
			ep = exceptionTranslator.translateException(ep);
		}

		if (ep instanceof BaseException) {
			return (BaseException) ep;
		}

		return new SystemException(ep);

	}

	private static void injectExceptionTranslators() {

		if (!TypeChecker.isNull(exceptionTranslators)) {
			return;
		}

		String[] beanNames = SpringApplicationContextHolder
				.getApplicationContext().getBeanNamesForType(
						ExceptionTranslator.class);

		if (TypeChecker.isEmpty(beanNames)) {

			exceptionTranslators = ObjectUtils.EMPTY_LIST;

			return;
		}

		exceptionTranslators = new ArrayList<ExceptionTranslator>(
				beanNames.length);

		for (String beanName : beanNames) {
			exceptionTranslators
					.add((ExceptionTranslator) SpringApplicationContextHolder
							.getBean(beanName));
		}
	}

	// Software caused connection abort: recv failed

	private ExceptionUtils() {

	}

	private static final int TRY_INVOCATIONTARGET_COUNTS = 10;

	private static List<ExceptionTranslator> exceptionTranslators = null;

}
