package com.rapid.j2ee.framework.core.exception.support;

import com.rapid.j2ee.framework.core.exception.BaseException;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.SystemException;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.exception.DatabaseConnectErrorApplicationException;

public class GeneralExceptionTranslator implements ExceptionTranslator {

	public BaseException translateException(Throwable throwable) {

		BaseException targetException = this.translateForEachCauses(throwable);

		if (!TypeChecker.isNull(targetException)) {
			return targetException;
		}

		if (throwable instanceof BaseException) {
			return (BaseException) throwable;
		}

		return new SystemException(throwable);
	}

	private BaseException translateForEachCauses(Throwable throwable) {

		while (throwable.getCause() != null) {

			BaseException translatedException = this
					.doTranslateThrowable(throwable.getCause());

			if (translatedException != null) {

				return translatedException;
			}

			throwable = throwable.getCause();
		}

		return this.doTranslateThrowable(throwable);

	}

	private BaseException doTranslateThrowable(Throwable throwable) {

		String error = ExceptionUtils.printThrowableStack(throwable)
				.toLowerCase();

		for (String keyword : exceptionErrorKeywords) {

			if (error.indexOf(keyword.toLowerCase()) >= 0) {

				return this.newThrowableTranslatedInstance(throwable);
			}

		}

		return null;

	}

	private BaseException newThrowableTranslatedInstance(Throwable throwable) {

		if (ConstructorUtils.isConstructorAvailable(exceptionClass,
				BaseException_Constructor_Arrays)) {
			return (BaseException) ConstructorUtils.newInstance(exceptionClass,
					BaseException_Constructor_Arrays,
					new Object[] { throwable });
		}

		return (BaseException) ConstructorUtils
				.newCacheInstance(exceptionClass);
	}

	public void setExceptionErrorKeywords(String[] exceptionErrorKeywords) {
		this.exceptionErrorKeywords = exceptionErrorKeywords;
	}

	public void setExceptionClassName(String exceptionClassName) {
		this.exceptionClass = ClassUtils.forName(exceptionClassName);
	}

	private Class exceptionClass = null;

	public static Class[] BaseException_Constructor_Arrays = new Class[] { Throwable.class };

	private String[] exceptionErrorKeywords = ObjectUtils.EMPTY_STRING_ARRAYS;

}
