package com.rapid.j2ee.framework.core.io;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseOutputStream extends OutputStream {

	private HttpServletResponse response;

	private HttpServletRequest request;

	private OutputStream os;

	public ResponseOutputStream(HttpServletRequest request,
			HttpServletResponse response) {
		this.response = response;
		this.request = request;
	}

	private OutputStream getOutputStream() throws IOException {

		if (os == null) {
			os = this.response.getOutputStream();
		}

		return os;
	}

	@Override
	public void write(int b) throws IOException {
		getOutputStream().write(b);
	}

	public void write(byte b[], int off, int len) throws IOException {
		getOutputStream().write(b, off, len);
	}

	public void flush() throws IOException {

		if (os == null) {
			return;
		}
		try {
			os.flush();
		} catch (Exception e) {

		}
	}

	public void close() throws IOException {

		if (os == null) {
			return;
		}
		try {
			os.close();
		} catch (Exception e) {

		}

	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

}
