package com.rapid.j2ee.framework.core.io.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.StringBuffers;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class FileReader {

	private BufferedReader br;

	private InputStreamReader isr;

	private String line;

	private boolean skipFirstLine;

	private boolean firstLine;

	private boolean trimLine = true;

	private final static int FILE_BUFFER_SIZE = 1024 * 2;

	public FileReader(File file, Charset charset) {
		try {
			initFileReader(new FileInputStream(file), charset);
		} catch (FileNotFoundException e) {
			this.close();
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public FileReader(InputStream is, Charset charset) {
		initFileReader(is, charset);
	}

	public FileReader(InputStream is) {
		initFileReader(is, Charsets.getCharsetInstance(CharsetType.ENGLISH));
	}

	private void initFileReader(InputStream is, Charset charset) {
		try {

			this.isr = new InputStreamReader(is, charset.getCharset());
			this.br = new BufferedReader(this.isr, FILE_BUFFER_SIZE);
			firstLine = true;
		} catch (UnsupportedEncodingException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public boolean hasNext() {
		try {

			this.line = br.readLine();

			if (TypeChecker.isNull(this.line)) {
				return false;
			}

			if (this.skipFirstLine && this.firstLine) {
				this.line = br.readLine();
			}

			if (TypeChecker.isNull(this.line)) {
				return false;
			}

			return true;

		} catch (IOException e) {
			this.close();
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	public boolean find(String value) {
		while (this.hasNext()) {
			if (("$$$" + this.readLine().toLowerCase()).indexOf(value) > 0) {
				return true;
			}
		}
		return false;
	}

	public String readAll() {

		StringBuffers sb = new StringBuffers(FILE_BUFFER_SIZE);

		while (hasNext()) {
			sb.appendln(this.readLine());
		}
		return sb.toString();
	}

	public void setNoTrimLine() {
		trimLine = false;
	}

	public String readLine() {

		return this.trimLine ? StringUtils.trimToEmpty(this.line) : this.line;
	}

	public void setSkipFirstLine(boolean b) {
		skipFirstLine = b;
	}

	public void close() {

		try {
			br.close();
		} catch (Exception e) {

		}
		try {
			isr.close();
		} catch (Exception e) {

		}

	}

	public static void main(String[] args) {
		try {

			InputStream is = FileUtils
					.getResourceAsStream("E:/ABMap/Dev/abmap_pkg_get_coordinates.bdy");

			System.out.println("is:" + is.available());

			FileReader fr = new FileReader(is, Charsets
					.getCharsetInstance(CharsetType.CHINESE));

			System.out.println(fr.readAll());

			fr.close();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

}
