package com.rapid.j2ee.framework.core.io.file;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class ObjectReader<T> {

	private String fileLocation;

	private InputStream fis = null;

	private ObjectInputStream ois = null;

	public ObjectReader(String fileLocation,
			ResourceLocationType resourceLocationType) {
		this.fileLocation = resourceLocationType.getFileType() + fileLocation;

	}

	public ObjectReader(String filePath, String fileName) {
		this(FileUtils.getFullFilePathName(filePath, fileName),
				ResourceLocationType.File);
	}

	public ObjectReader(File file) {
		this(file.getAbsolutePath(), ResourceLocationType.File);
	}

	public ObjectReader(InputStream is) {
		this.fis = is;

	}

	private void open() {
		try {

			if (TypeChecker.isNull(fis)) {

				this.fis = ResourceUtils.getResource(this.fileLocation)
						.getInputStream();

			}

			ois = new ObjectInputStream(fis);

		} catch (Exception ex) {
			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}
	}

	public T read() {
		try {
			this.open();
			return (T) this.ois.readObject();
		} catch (Exception ex) {
			throw ExceptionUtils.convertThrowableToBaseException(ex);
		} finally {
			this.close();
		}
	}

	public void close() {

		try {
			this.ois.close();
		} catch (Exception ex) {
		}
		try {
			this.fis.close();
		} catch (Exception ex) {
		}
	}

	public static void main(String[] args) {

	}

}