package com.rapid.j2ee.framework.core.io.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;

public class ObjectWriter {

	private FileOutputStream fos = null;

	private ObjectOutputStream oos = null;

	private File file;

	public ObjectWriter(String fileName) {
		this(null, fileName);
	}

	public ObjectWriter(String filePath, String fileName) {

		this.file = FileUtils.getFile(filePath, fileName);

	}

	public ObjectWriter(File file) {
		this.file = file;

	}

	private void open() {
		try {

			fos = new FileOutputStream(file);
			oos = new ObjectOutputStream(fos);
		} catch (Exception ex) {
			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}
	}

	public void write(Object obj) {
		try {
			this.open();
			this.oos.writeObject(obj);
		} catch (Exception ex) {
			throw ExceptionUtils.convertThrowableToBaseException(ex);
		} finally {
			this.close();
		}
	}

	public void close() {
		try {
			this.oos.flush();
		} catch (Exception ex) {
		}
		try {
			this.fos.flush();
		} catch (Exception ex) {
		}
		try {
			this.oos.close();
		} catch (Exception ex) {
		}
		try {
			this.fos.close();
		} catch (Exception ex) {
		}
	}

	/**
	 * @return
	 */
	public File getFile() {
		return file;
	}

	public static void main(String[] args) {

		ObjectWriter wr = new ObjectWriter(
				"G:/Workspace(JohnHao)/ABIT/eMap_Workspace/ChinaeTax/src/main/resources/test.data");
		wr.write("郝海蛟");
		wr.close();

		System.out.println(wr.getFile().getAbsolutePath());

		ObjectReader or = new ObjectReader("test.data",
				ResourceLocationType.ClassPath);

		System.out.println(or.read());

		or.close();

	}

}