package com.rapid.j2ee.framework.core.io.file;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;

public class ResourceChangedDetector {

	public ResourceChangedDetector() {
		resourceModifyTimeMap = new HashMap<String, Long>();
	}

	protected final boolean isResourceModified(Resource resource) {

		try {

			Assert.notNull(resource.getFile());

			String key = resource.getFile().getAbsolutePath();

			long lastResourceTime = resource.getFile().lastModified();

			if (!resourceModifyTimeMap.containsKey(key)) {
				resourceModifyTimeMap.put(key, lastResourceTime);
				return true;
			}

			if (resourceModifyTimeMap.get(key).longValue() == lastResourceTime) {
				return false;
			}

			resourceModifyTimeMap.put(key, lastResourceTime);

			return true;

		} catch (IOException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	private Map<String, Long> resourceModifyTimeMap = null;

}
