package com.rapid.j2ee.framework.core.io.http;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.NetworkDisconnectSystemException;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class HttpContentBodyRequestClient {

	private HttpClient client;

	private String requestUrl;

	private HttpPost httpPost;

	private String charset;

	private String contentType = "";

	public HttpContentBodyRequestClient(String requestUrl, String charset) {

		client = new DefaultHttpClient();
		this.requestUrl = requestUrl;
		httpPost = new HttpPost(this.requestUrl);
		this.charset = charset;
		// timeout 15sec
		this.setConnectionTimeout(1000 * 15);

	}

	public void addHeader(String name, String value) {
		httpPost.addHeader(name, value);
	}

	public void setHeader(String name, String value) {
		httpPost.setHeader(name, value);
	}

	public void setConnectionTimeout(int timeout) {
		client.getParams().setIntParameter("http.socket.timeout", timeout);
	}

	public HttpResponseEntity execute(String content) {

		try {
			// Construct a string entity
			StringEntity entity = new StringEntity(content, this.charset);

			this.httpPost.setEntity(entity);

			// Set content type of request header

			if (!TypeChecker.isEmpty(this.getContentType(charset))) {

				httpPost
						.setHeader("Content-Type", this.getContentType(charset));
			}

			// Execute request and get the response
			HttpResponse response = client.execute(this.httpPost);

			int statusCode = response.getStatusLine().getStatusCode();

			if (statusCode != 200) {
				throw new RuntimeException("Sorry, Cannot connect to "
						+ this.requestUrl + "! Returned status code :"
						+ +statusCode);
			}

			return new HttpResponseEntity(response, response.getEntity(),
					statusCode);

		} catch (java.net.ConnectException connectException) {
			throw new NetworkDisconnectSystemException(
					"Sorry, Cannot connect to " + this.requestUrl,
					connectException);
		} catch (Exception e) {

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public String executeContent(String content) {
		try {
			HttpResponseEntity entity = execute(content);

			try {

				return EntityUtils.toString(entity, this.charset);

			} catch (Exception e) {

				throw ExceptionUtils.convertThrowableToBaseException(e);
			}

		} finally {
			this.shutdown();
		}

	}

	public String executeContentWithoutExp(String content) {

		try {
			HttpResponseEntity entity = execute(content);

			return EntityUtils.toString(entity, this.charset);

		} catch (Exception e) {

			return "";
		}

		finally {
			this.shutdown();
		}

	}

	protected String getContentType(String charset) {

		return this.contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	public void shutdown() {

		try {
			this.client.getConnectionManager().shutdown();
		} catch (Exception e) {

		}
	}

}
